/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContainerSupport {
    private final MBeanServer mMBeanServer;
    private final ObjectName mOwnerObjectName;
    private final ConcurrentMap<String, Set<ObjectName>> mContainees = new ConcurrentHashMap<String, Set<ObjectName>>();
    private static final Map<String, ObjectName> EMPTY_MAP = Collections.emptyMap();

    protected static void debug(String s) {
        System.out.println(s);
    }

    public ContainerSupport(MBeanServer mbeanServer, ObjectName objectName) {
        this.mMBeanServer = mbeanServer;
        this.mOwnerObjectName = objectName;
        if (this.mMBeanServer == null || objectName == null) {
            throw new IllegalArgumentException();
        }
    }

    public void containeeRegistered(ObjectName objectName) {
        this.addContainee(objectName);
    }

    public void containeeUnregistered(ObjectName objectName) {
        this.removeContainee(objectName);
    }

    public synchronized void addContainee(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType((ObjectName)objectName);
        HashSet<ObjectName> items = (HashSet<ObjectName>)this.mContainees.get(j2eeType);
        if (items == null) {
            items = new HashSet<ObjectName>();
        }
        items.add(objectName);
        this.mContainees.put(j2eeType, items);
    }

    public synchronized void removeContainee(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType((ObjectName)objectName);
        Set items = (Set)this.mContainees.get(j2eeType);
        items.remove(objectName);
    }

    public synchronized Set<String> getContaineeJ2EETypes() {
        return Collections.unmodifiableSet(this.mContainees.keySet());
    }

    public synchronized Set<ObjectName> getContaineeObjectNameSet(String j2eeType) {
        Set<ObjectName> result = (Set<ObjectName>)this.mContainees.get(j2eeType);
        result = result == null ? Collections.emptySet() : Collections.unmodifiableSet(result);
        return result;
    }

    public Set<ObjectName> getContaineeObjectNameSet(Set<String> j2eeTypes) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (String j2eeType : j2eeTypes) {
            result.addAll(this.getContaineeObjectNameSet(j2eeType));
        }
        return result;
    }

    public final ObjectName getContaineeObjectName(String j2eeType) {
        Set<ObjectName> children = this.getContaineeObjectNameSet(j2eeType);
        ObjectName result = null;
        if (children.size() == 1) {
            result = (ObjectName)GSetUtil.getSingleton(children);
        } else if (children.size() == 0) {
            result = null;
        } else {
            throw new UnsupportedOperationException("getContaineeObjectName");
        }
        return result;
    }

    public final ObjectName getNamedChildObjectName(String name) {
        return this.getContaineeObjectName(this.getChildJ2EEType(), name);
    }

    public final ObjectName getContaineeObjectName(String j2eeType, String name) {
        Set<ObjectName> candidates = this.getContaineeObjectNameSet(j2eeType);
        Set matching = JMXUtil.findByProperty(candidates, (String)"name", (String)name);
        ObjectName result = matching.size() == 0 ? null : (ObjectName)GSetUtil.getSingleton((Set)matching);
        return result;
    }

    public Map<String, Map<String, ObjectName>> getMultiContaineeObjectNameMap(Set<String> j2eeTypesIn) {
        Set<String> j2eeTypes = j2eeTypesIn == null ? this.getContaineeJ2EETypes() : j2eeTypesIn;
        HashMap<String, Map<String, ObjectName>> m = new HashMap<String, Map<String, ObjectName>>();
        for (String j2eeType : j2eeTypes) {
            Map<String, ObjectName> nameMap = this.getContaineeObjectNameMap(j2eeType);
            if (nameMap.keySet().size() == 0) continue;
            m.put(j2eeType, nameMap);
        }
        return m;
    }

    public final Map<String, ObjectName> getContaineeObjectNameMap(String j2eeType) {
        if (!this.getContaineeJ2EETypes().contains(j2eeType)) {
            return EMPTY_MAP;
        }
        Set<ObjectName> objectNames = this.getContaineeObjectNameSet(j2eeType);
        Map result = Collections.emptyMap();
        if (objectNames.size() != 0) {
            result = Util.createObjectNameMap(objectNames);
        }
        assert (result.keySet().size() == objectNames.size());
        return result;
    }

    public Set<ObjectName> getByNameContaineeObjectNameSet(Set<String> j2eeTypes, String name) {
        Set<ObjectName> items = this.getContaineeObjectNameSet(j2eeTypes);
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (ObjectName objectName : items) {
            if (!Util.getName((ObjectName)objectName).equals(name)) continue;
            result.add(objectName);
        }
        return result;
    }

    public final Set<ObjectName> getContaineeObjectNameSet() {
        String selfType = Util.getJ2EEType((ObjectName)this.mOwnerObjectName);
        HashSet<ObjectName> allChildren = new HashSet<ObjectName>();
        for (String j2eeType : this.getContaineeJ2EETypes()) {
            Set<ObjectName> childrenOfType = this.getContaineeObjectNameSet(j2eeType);
            allChildren.addAll(childrenOfType);
        }
        return allChildren;
    }

    public String getChildJ2EEType() {
        Set<String> types = this.getContaineeJ2EETypes();
        if (types.size() != 1) {
            ContainerSupport.debug("getChildJ2EEType failing on: " + this.mOwnerObjectName + ", got this many children: " + types.size());
            throw new IllegalArgumentException(SmartStringifier.toString(types));
        }
        return (String)GSetUtil.getSingleton(types);
    }

    public final String[] getChildNames() {
        return this.getContaineeNamesOfType(this.getChildJ2EEType());
    }

    public final String[] getContaineeNamesOfType(String j2eeType) {
        Set<ObjectName> objectNames = this.getContaineeObjectNameSet(j2eeType);
        return this.getNamePropertyValues(objectNames);
    }

    public ObjectName getOnlyChildObjectName() {
        return this.getContaineeObjectName(this.getChildJ2EEType());
    }

    protected final String[] getNamePropertyValues(Set<ObjectName> objectNameSet) {
        return JMXUtil.getKeyProperty((String)"name", objectNameSet);
    }
}

