/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanInfo;
import org.glassfish.admin.amx.mbean.DelegateBase;
import org.glassfish.admin.amx.mbean.NameMapping;
import org.jvnet.hk2.config.ConfigBean;

public final class DelegateToConfigBeanDelegate
extends DelegateBase {
    private final ConfigBean mConfigBean;
    private static final String[] SINGLE_STRING_SIG = new String[]{String.class.getName()};

    private static void debug(String s) {
        System.out.println(s);
    }

    public DelegateToConfigBeanDelegate(ConfigBean configBean) {
        super("DelegateToConfigBeanDelegate." + configBean.toString());
        this.mConfigBean = configBean;
    }

    private final String getXMLName(String amxName) {
        String xmlName = NameMapping.getXMLName(amxName);
        if (xmlName == null) {
            Set xmlNames = this.mConfigBean.getAttributeNames();
            xmlName = NameMapping.matchAMXName(amxName, xmlNames);
        }
        return xmlName;
    }

    public final Object getAttribute(String attrName) throws AttributeNotFoundException {
        String xmlName = this.getXMLName(attrName);
        return this.mConfigBean.rawAttribute(xmlName);
    }

    protected final String _getDefaultValue(String name) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(name);
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.mConfigBean.attribute(this.getXMLName(attr.getName()), "" + attr.getValue());
    }

    public MBeanInfo getMBeanInfo() {
        return null;
    }

    private void delegateFailed(Throwable t) {
        if (this.getOwner() != null) {
            this.getOwner().delegateFailed(t);
        }
    }

    public final Object invoke(String operationName, Object[] args, String[] types) {
        throw new RuntimeException("invoke() not yet implemented");
    }
}

