/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameMapping {
    private static final NameMapping INSTANCE = new NameMapping();
    private final ConcurrentMap<String, String> mAMXToXML = new ConcurrentHashMap<String, String>();

    private NameMapping() {
    }

    public static String getXMLName(String amxName) {
        return (String)NameMapping.INSTANCE.mAMXToXML.get(amxName);
    }

    public static String matchAMXName(String amxName, Set<String> xmlCandidates) {
        String amxCanonical;
        String xmlName = amxCanonical = amxName.toLowerCase();
        for (String xmlCandidate : xmlCandidates) {
            String temp = xmlCandidate.replace("-", "");
            if (!temp.equals(amxCanonical)) continue;
            xmlName = xmlCandidate;
            break;
        }
        NameMapping.INSTANCE.mAMXToXML.put(amxName, xmlName);
        return xmlName;
    }
}

