/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.module.common_impl.Jar;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryImpl
implements Repository {
    private final String name;
    private final URI location;
    private Map<String, ModuleDefinition> moduleDefs;
    private List<URI> libraries;
    protected List<RepositoryChangeListener> listeners;
    private List<ModuleDefinition> allModules;

    public AbstractRepositoryImpl(String name, URI location) {
        this.name = name;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public ModuleDefinition find(String name, String version) {
        return this.moduleDefs.get(name);
    }

    @Override
    public List<ModuleDefinition> findAll() {
        return this.allModules;
    }

    @Override
    public List<ModuleDefinition> findAll(String name) {
        return Collections.singletonList(this.moduleDefs.get(name));
    }

    @Override
    public void initialize() throws IOException {
        this.moduleDefs = new HashMap<String, ModuleDefinition>();
        this.libraries = new ArrayList<URI>();
        this.loadModuleDefs(this.moduleDefs, this.libraries);
        this.allModules = Collections.unmodifiableList(new ArrayList<ModuleDefinition>(this.moduleDefs.values()));
    }

    protected abstract void loadModuleDefs(Map<String, ModuleDefinition> var1, List<URI> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleDefinition loadJar(File jar) throws IOException {
        Attributes attr;
        String bundleName;
        Jar jarFile = Jar.create(jar);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null || manifest.getMainAttributes().getValue("HK2-Bundle-Name") == null) {
            String simpleName = jarFile.getBaseName();
            File manifestFile = new File(jar.getParentFile(), simpleName + ".mf");
            if (manifestFile.exists()) {
                InputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(manifestFile));
                    manifest = new Manifest(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        if (manifest != null && (bundleName = (attr = manifest.getMainAttributes()).getValue("HK2-Bundle-Name")) != null) {
            return this.newModuleDefinition(jar, attr);
        }
        return null;
    }

    protected void add(ModuleDefinition def) {
        this.moduleDefs.put(def.getName(), def);
    }

    protected void remove(ModuleDefinition def) {
        this.moduleDefs.remove(def.getName());
    }

    protected void addLibrary(URI location) {
        this.libraries.add(location);
    }

    protected void removeLibrary(URI location) {
        this.libraries.remove(location);
    }

    @Override
    public void shutdown() throws IOException {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (ModuleDefinition moduleDef : this.findAll()) {
            s.append(moduleDef.getName()).append(":");
        }
        return s.toString();
    }

    @Override
    public Module newModule(ModulesRegistry registry, ModuleDefinition moduleDef) {
        return AbstractFactory.getInstance().createModule(registry, moduleDef);
    }

    @Override
    public List<URI> getJarLocations() {
        return Collections.unmodifiableList(this.libraries);
    }

    @Override
    public synchronized boolean addListener(RepositoryChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RepositoryChangeListener>();
        }
        return this.listeners.add(listener);
    }

    @Override
    public synchronized boolean removeListener(RepositoryChangeListener listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(this.listeners);
    }

    protected ModuleDefinition newModuleDefinition(File jar, Attributes attr) throws IOException {
        return new DefaultModuleDefinition(jar, attr);
    }
}

