/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.impl.ClassLoaderProxy;
import com.sun.enterprise.module.impl.ModuleImpl;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.impl.Utils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModuleClassLoader
extends ClassLoaderProxy {
    private final ModuleImpl module;
    private volatile boolean initialized = false;
    private StackTraceElement[] initializerThread;
    private String initializerClassName;
    private static final String META_INF_SERVICES = "META-INF/services/";

    public ModuleClassLoader(ModuleImpl owner, URL[] shared, ClassLoader parent) {
        super(shared, parent);
        this.module = owner;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Utils.getDefaultLogger().info("ModuleClassLoader gc'ed " + this.module.getModuleDefinition().getName());
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.initialize(name);
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        this.initialize(name);
        if (name.startsWith(META_INF_SERVICES)) {
            String serviceName = name.substring(META_INF_SERVICES.length());
            ModulesRegistryImpl reg = this.module.getRegistry();
            for (Module m : reg.getModules()) {
                List<URL> list = m.getMetadata().getDescriptors(serviceName);
                if (list.isEmpty()) continue;
                return list.get(0);
            }
            return null;
        }
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        if (name.endsWith(".class")) {
            String className = name.replace('/', '.').substring(0, name.length() - 6);
            ModuleImpl m = this.module.getRegistry().getProvidingModule(className);
            if (m != null) {
                return m.getPrivateClassLoader().getResource(name);
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        this.initialize(name);
        if (name.startsWith(META_INF_SERVICES)) {
            String serviceName = name.substring(META_INF_SERVICES.length());
            Vector<URL> urls = new Vector<URL>();
            ModulesRegistryImpl reg = this.module.getRegistry();
            for (Module m : reg.getModules()) {
                urls.addAll(m.getMetadata().getDescriptors(serviceName));
            }
            return urls.elements();
        }
        return super.getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(String name) {
        if (this.initialized) {
            return;
        }
        ModuleClassLoader moduleClassLoader = this;
        synchronized (moduleClassLoader) {
            if (!this.initialized) {
                if (this.module.getState().equals((Object)ModuleState.VALIDATING)) {
                    return;
                }
                this.initialized = true;
                this.module.start();
                this.initializerThread = Thread.currentThread().getStackTrace();
                this.initializerClassName = name;
            }
        }
    }

    void dumpState(PrintStream writer) {
        writer.println("Class-Path:");
        for (URL uRL : this.getURLs()) {
            writer.println("  " + uRL);
        }
        if (this.initializerThread != null) {
            writer.println("Initialized when " + this.initializerClassName + " was requested by :");
            for (Serializable serializable : this.initializerThread) {
                writer.println("  " + ((StackTraceElement)serializable).toString());
            }
        }
    }

    @Override
    public void stop() {
        if (!this.module.isSticky()) {
            Utils.getDefaultLogger().info("ModuleClassLoader stopped " + this.module.getModuleDefinition().getName());
            super.stop();
            this.module.stop();
        }
    }

    public ModuleImpl getOwner() {
        return this.module;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("ModuleClassLoader(name=").append(this.module.getName());
        s.append(", parent=").append(super.toString());
        s.append(",init=").append(this.initialized);
        s.append(",URls[]=");
        for (URL url : this.getURLs()) {
            s.append(url).append(",");
        }
        s.append(")");
        for (ClassLoader surrogate : super.getDelegates()) {
            s.append("\n ref : ").append(surrogate.toString());
        }
        return s.toString();
    }
}

