/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.ImportPolicy;
import com.sun.enterprise.module.LifecyclePolicy;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.impl.ClassLoaderFacade;
import com.sun.enterprise.module.impl.ModuleClassLoader;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.impl.Utils;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleImpl
implements Module {
    private ModuleDefinition moduleDef;
    private WeakReference<ClassLoader> publicCL;
    private volatile ModuleClassLoader privateCL;
    private final Map<String, List<Class>> serviceClasses = new ConcurrentHashMap<String, List<Class>>();
    private final ModulesRegistryImpl registry;
    private ModuleState state;
    private final List<Module> dependencies = new ArrayList<Module>();
    private final ArrayList<ModuleChangeListener> listeners = new ArrayList();
    private final HashMap<String, Long> lastModifieds = new HashMap();
    private boolean shared = true;
    private boolean sticky = false;
    private LifecyclePolicy lifecyclePolicy = null;

    ModuleImpl(ModulesRegistryImpl registry, ModuleDefinition info) {
        assert (registry != null && info != null);
        this.registry = registry;
        this.moduleDef = info;
        for (URI lib : info.getLocations()) {
            File f = new File(lib);
            if (!f.exists()) continue;
            this.lastModifieds.put(f.getAbsolutePath(), f.lastModified());
        }
        this.state = ModuleState.NEW;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader r = null;
        if (this.publicCL != null) {
            r = (ClassLoader)this.publicCL.get();
        }
        if (r != null) {
            return r;
        }
        ClassLoaderFacade facade = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderFacade>(){

            @Override
            public ClassLoaderFacade run() {
                return new ClassLoaderFacade(ModuleImpl.this.getPrivateClassLoader());
            }
        });
        facade.setPublicPkgs(this.moduleDef.getPublicInterfaces());
        this.publicCL = new WeakReference<ClassLoaderFacade>(facade);
        return facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleClassLoader getPrivateClassLoader() {
        if (this.privateCL == null) {
            ModuleImpl moduleImpl = this;
            synchronized (moduleImpl) {
                if (this.privateCL == null) {
                    URI[] locations = this.moduleDef.getLocations();
                    URL[] urlLocations = new URL[locations.length];
                    for (int i = 0; i < locations.length; ++i) {
                        try {
                            urlLocations[i] = locations[i].toURL();
                            continue;
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    final URL[] urls = (URL[])urlLocations.clone();
                    this.privateCL = AccessController.doPrivileged(new PrivilegedAction<ModuleClassLoader>(){

                        @Override
                        public ModuleClassLoader run() {
                            return new ModuleClassLoader(ModuleImpl.this, urls, ModuleImpl.this.registry.getParentClassLoader());
                        }
                    });
                }
            }
        }
        return this.privateCL;
    }

    @Override
    public ModuleDefinition getModuleDefinition() {
        return this.moduleDef;
    }

    @Override
    public ModulesRegistryImpl getRegistry() {
        return this.registry;
    }

    @Override
    public void detach() {
        this.registry.remove(this);
    }

    public String toString() {
        return "Module: " + this.moduleDef.getName() + "::" + (this.privateCL == null ? "none" : this.privateCL.toString());
    }

    @Override
    public void addListener(ModuleChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ModuleChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChangeEvent() {
        ArrayList<ModuleChangeListener> list = new ArrayList<ModuleChangeListener>(this.listeners);
        for (ModuleChangeListener listener : list) {
            listener.changed(this);
        }
        this.registry.changed(this);
    }

    @Override
    public void refresh() {
        URI[] urls;
        for (URI lib : urls = this.moduleDef.getLocations()) {
            File f = new File(lib);
            if (!f.exists() || !this.lastModifieds.containsKey(f.getAbsolutePath()) || this.lastModifieds.get(f.getAbsolutePath()).longValue() == f.lastModified()) continue;
            this.fireChangeEvent();
            this.detach();
            return;
        }
    }

    @Override
    public ModuleMetadata getMetadata() {
        return this.moduleDef.getMetadata();
    }

    void parseInhabitants(String name, InhabitantsParser parser) throws IOException {
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                return ModuleImpl.this.getPrivateClassLoader();
            }
        };
        for (ModuleMetadata.InhabitantsDescriptor d : this.getMetadata().getHabitats(name)) {
            parser.parse(d.createScanner(), (Holder)holder);
        }
    }

    @Override
    public synchronized void resolve() throws ResolveError {
        if (this.state == ModuleState.ERROR) {
            throw new ResolveError("Module " + this.getName() + " is in ERROR state");
        }
        if (this.state.compareTo(ModuleState.RESOLVED) >= 0) {
            return;
        }
        if (this.state == ModuleState.VALIDATING) {
            Utils.identifyCyclicDependency(this, Logger.getAnonymousLogger());
            throw new ResolveError("Cyclic dependency with " + this.getName());
        }
        this.state = ModuleState.VALIDATING;
        if (this.moduleDef.getImportPolicyClassName() != null) {
            try {
                Class<?> importPolicyClass = this.getPrivateClassLoader().loadClass(this.moduleDef.getImportPolicyClassName());
                ImportPolicy importPolicy = (ImportPolicy)importPolicyClass.newInstance();
                importPolicy.prepare(this);
            }
            catch (ClassNotFoundException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(e);
            }
            catch (InstantiationException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(e);
            }
            catch (IllegalAccessException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(e);
            }
        }
        for (ModuleDependency dependency : this.moduleDef.getDependencies()) {
            ModuleImpl depModule = (ModuleImpl)ModuleImpl.class.cast(this.registry.makeModuleFor(dependency.getName(), null));
            if (depModule == null) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(dependency + " referenced from " + this.moduleDef.getName() + " is not resolved");
            }
            this.addImport(depModule);
        }
        this.state = ModuleState.RESOLVED;
        if (this.moduleDef.getLifecyclePolicyClassName() != null) {
            try {
                Class<?> lifecyclePolicyClass = this.getPrivateClassLoader().loadClass(this.moduleDef.getLifecyclePolicyClassName());
                this.lifecyclePolicy = (LifecyclePolicy)lifecyclePolicyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError("ClassNotFound : " + e.getMessage(), e);
            }
            catch (InstantiationException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(e);
            }
            catch (IllegalAccessException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError(e);
            }
            this.lifecyclePolicy.load(this);
        }
        for (ModuleLifecycleListener listener : this.registry.getLifecycleListeners()) {
            listener.moduleStarted(this);
        }
    }

    @Override
    public void start() throws ResolveError {
        if (this.state == ModuleState.READY) {
            return;
        }
        this.resolve();
        this.state = ModuleState.READY;
        try {
            for (Module subModules : this.dependencies) {
                subModules.start();
            }
        }
        catch (ResolveError e) {
            this.state = ModuleState.RESOLVED;
            throw e;
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.start(this);
        }
    }

    @Override
    public boolean stop() {
        if (this.sticky) {
            return false;
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.stop(this);
            this.lifecyclePolicy = null;
        }
        this.detach();
        for (Module subModule : this.dependencies) {
            if (((ModuleImpl)ModuleImpl.class.cast(subModule)).isShared()) continue;
            subModule.stop();
        }
        this.privateCL = null;
        this.publicCL = null;
        this.dependencies.clear();
        this.state = ModuleState.NEW;
        return true;
    }

    @Override
    public List<Module> getImports() {
        return this.dependencies;
    }

    @Override
    public Module addImport(ModuleDependency dependency) {
        ModuleImpl newModule = dependency.isShared() ? (ModuleImpl)ModuleImpl.class.cast(this.registry.makeModuleFor(dependency.getName(), dependency.getVersion())) : this.registry.newPrivateModuleFor(dependency.getName(), dependency.getVersion());
        this.addImport(newModule);
        return newModule;
    }

    @Override
    public ModuleState getState() {
        return this.state;
    }

    @Override
    public void addImport(Module module) {
        if (!this.dependencies.contains(module)) {
            this.dependencies.add(module);
            this.getPrivateClassLoader().addDelegate(module.getClassLoader());
        }
    }

    public void removeImport(ModuleImpl module) {
        if (this.dependencies.contains(module)) {
            this.dependencies.remove(module);
            this.getPrivateClassLoader().removeDelegate(module.getClassLoader());
        }
    }

    @Override
    public String getName() {
        if (this.getModuleDefinition() != null) {
            return this.getModuleDefinition().getName();
        }
        return "unknown module";
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    void setShared(boolean sharable) {
        this.shared = sharable;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    @Override
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public <T> Iterable<Class<? extends T>> getProvidersClass(Class<T> serviceClass) {
        return this.getProvidersClass(serviceClass.getName());
    }

    @Override
    public Iterable<Class> getProvidersClass(String name) {
        List r = this.serviceClasses.get(name);
        if (r != null) {
            return r;
        }
        for (String provider : this.getMetadata().getEntry((String)name).providerNames) {
            if (r == null) {
                r = new ArrayList<Class>();
            }
            try {
                r.add(this.getPrivateClassLoader().loadClass(provider));
            }
            catch (ClassNotFoundException e) {
                Utils.getDefaultLogger().log(Level.SEVERE, "Failed to load " + provider + " from " + this.getName(), e);
            }
        }
        if (r == null) {
            r = Collections.emptyList();
        }
        this.serviceClasses.put(name, r);
        return r;
    }

    @Override
    public boolean hasProvider(Class serviceClass) {
        String name = serviceClass.getName();
        List<Class> v = this.serviceClasses.get(name);
        if (v != null && !v.isEmpty()) {
            return true;
        }
        return this.getMetadata().getEntry(name).hasProvider();
    }

    @Override
    public void dumpState(PrintStream writer) {
        writer.println("Module " + this.getName() + " Dump");
        writer.println("State " + (Object)((Object)this.getState()));
        for (Module imported : this.getImports()) {
            writer.println("Depends on " + imported.getName());
        }
        if (this.publicCL != null) {
            ClassLoaderFacade cloader = (ClassLoaderFacade)this.publicCL.get();
            cloader.dumpState(writer);
        }
    }

    public static ModuleImpl find(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            return null;
        }
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getOwner();
        }
        return null;
    }
}

