/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.appserv.connectors.spi.ResourceHandle;
import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaEETransaction
extends TimerTask
implements com.sun.enterprise.container.common.spi.JavaEETransaction {
    @Inject
    static Logger _logger;
    private static StringManager sm;
    @Inject
    static JavaEETransactionManager javaEETM;
    private static long txIdCounter;
    private long txId;
    private JavaEEXid xid;
    private Transaction jtsTx;
    private ResourceHandle nonXAResource;
    private ResourceHandle laoResource;
    private int localTxStatus = 0;
    private Vector syncs = new Vector();
    private Vector interposedSyncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private boolean isTimedOut = false;
    private boolean isTimerTask = false;
    private int timeout = 0;
    private boolean imported = false;
    private HashMap resourceTable;
    private HashMap<Object, Object> userResourceMap;
    private Object activeTxCache;
    private Map<EntityManagerFactory, EntityManager> txEntityManagerMap;
    private Map<EntityManagerFactory, EntityManager> extendedEntityManagerMap;
    private String componentName = null;
    private ArrayList<String> resourceNames = null;
    private Object containerData = null;
    private static boolean isTimerInitialized;
    private static Timer timer;
    private static final byte[] bqual;

    private static synchronized void initializeTimer() {
        if (isTimerInitialized) {
            return;
        }
        timer = new Timer(true);
        isTimerInitialized = true;
    }

    JavaEETransaction() {
        this.txId = JavaEETransaction.getNewTxId();
        this.xid = new JavaEEXid(this.txId);
        this.resourceTable = new HashMap();
        this.startTime = System.currentTimeMillis();
        if (_logger != null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--Created new JavaEETransaction, txId = " + this.txId);
        }
    }

    JavaEETransaction(int timeout) {
        this();
        if (!isTimerInitialized) {
            JavaEETransaction.initializeTimer();
        }
        timer.schedule((TimerTask)this, timeout * 1000);
        this.isTimerTask = true;
        this.timeout = timeout;
    }

    JavaEETransaction(Transaction jtsTx) {
        this();
        this.jtsTx = jtsTx;
    }

    @Override
    public void run() {
        this.isTimedOut = true;
        try {
            this.setRollbackOnly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object data) {
        this.containerData = data;
    }

    boolean isAssociatedTimeout() {
        return this.isTimerTask;
    }

    int cancelTimerTask() {
        this.cancel();
        return this.timeout;
    }

    boolean isTimedout() {
        return this.isTimedOut;
    }

    private static synchronized long getNewTxId() {
        long newTxId = txIdCounter++;
        return newTxId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JavaEETransaction) {
            JavaEETransaction othertx = (JavaEETransaction)other;
            return this.txId == othertx.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    public ResourceHandle getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(ResourceHandle h) {
        this.nonXAResource = h;
    }

    ResourceHandle getLAOResource() {
        return this.laoResource;
    }

    void setLAOResource(ResourceHandle h) {
        this.laoResource = h;
    }

    void setImportedTransaction() {
        this.imported = true;
    }

    boolean isImportedTransaction() {
        return this.imported;
    }

    synchronized void putUserResource(Object key, Object value) {
        if (this.userResourceMap == null) {
            this.userResourceMap = new HashMap();
        }
        this.userResourceMap.put(key, value);
    }

    synchronized Object getUserResource(Object key) {
        if (this.userResourceMap == null) {
            return null;
        }
        return this.userResourceMap.get(key);
    }

    void registerInterposedSynchronization(Synchronization sync) {
        this.interposedSyncs.add(sync);
    }

    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    String getComponentName() {
        return this.componentName;
    }

    synchronized void addResourceName(String resourceName) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList();
        }
        this.resourceNames.add(resourceName);
    }

    synchronized ArrayList<String> getResourceNames() {
        return this.resourceNames;
    }

    public void addTxEntityManagerMapping(EntityManagerFactory emf, EntityManager em) {
        this.getTxEntityManagerMap().put(emf, em);
    }

    public EntityManager getTxEntityManager(EntityManagerFactory emf) {
        return this.getTxEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, EntityManager> getTxEntityManagerMap() {
        if (this.txEntityManagerMap == null) {
            this.txEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.txEntityManagerMap;
    }

    private void onTxCompletion(boolean status) {
        for (Map.Entry<EntityManagerFactory, EntityManager> entry : this.getTxEntityManagerMap().entrySet()) {
            EntityManager em = entry.getValue();
            if (!em.isOpen()) continue;
            try {
                em.close();
            }
            catch (Throwable th) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Exception while closing em.", th);
            }
        }
    }

    public void addExtendedEntityManagerMapping(EntityManagerFactory emf, EntityManager em) {
        this.getExtendedEntityManagerMap().put(emf, em);
    }

    public void removeExtendedEntityManagerMapping(EntityManagerFactory emf) {
        this.getExtendedEntityManagerMap().remove(emf);
    }

    public EntityManager getExtendedEntityManager(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, EntityManager> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.extendedEntityManagerMap;
    }

    boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(Transaction jtsTx) throws RollbackException, SystemException {
        this.jtsTx = jtsTx;
        if (!this.commitStarted) {
            for (int i = 0; i < this.syncs.size(); ++i) {
                jtsTx.registerSynchronization((Synchronization)this.syncs.elementAt(i));
            }
        }
    }

    Transaction getJTSTx() {
        return this.jtsTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block40: {
            Exception ex62;
            Synchronization sync3;
            int i3;
            if (this.isTimerTask) {
                this.cancel();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "--In JavaEETransaction.commit, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
            }
            this.commitStarted = true;
            if (this.jtsTx != null) {
                try {
                    this.jtsTx.commit();
                }
                finally {
                    ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                    this.onTxCompletion(true);
                }
            }
            try {
                block39: {
                    Synchronization sync2;
                    int i2;
                    if (this.isTimedOut) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.rollback_timeout"));
                    }
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    for (i2 = 0; i2 < this.syncs.size(); ++i2) {
                        try {
                            sync2 = (Synchronization)this.syncs.elementAt(i2);
                            sync2.beforeCompletion();
                            continue;
                        }
                        catch (RuntimeException ex2) {
                            this.setRollbackOnly();
                            continue;
                        }
                        catch (Exception ex3) {
                            // empty catch block
                        }
                    }
                    for (i2 = 0; i2 < this.interposedSyncs.size(); ++i2) {
                        try {
                            sync2 = (Synchronization)this.interposedSyncs.elementAt(i2);
                            sync2.beforeCompletion();
                            continue;
                        }
                        catch (RuntimeException ex4) {
                            this.setRollbackOnly();
                            continue;
                        }
                        catch (Exception ex5) {
                            // empty catch block
                        }
                    }
                    if (this.isRollbackOnly()) {
                        if (this.jtsTx == null) {
                            if (this.nonXAResource != null) {
                                this.nonXAResource.getXAResource().rollback(this.xid);
                            }
                            this.localTxStatus = 4;
                            throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                        }
                        this.jtsTx.rollback();
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    if (this.jtsTx != null) {
                        this.jtsTx.commit();
                        this.localTxStatus = 3;
                        break block39;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().commit(this.xid, true);
                    }
                    this.localTxStatus = 3;
                }
                Object var4_12 = null;
                ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
            }
            catch (Throwable throwable) {
                Exception ex62;
                Synchronization sync3;
                int i3;
                Object var4_13 = null;
                ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
                for (i3 = 0; i3 < this.interposedSyncs.size(); ++i3) {
                    try {
                        sync3 = (Synchronization)this.interposedSyncs.elementAt(i3);
                        sync3.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception ex62) {
                        // empty catch block
                    }
                }
                for (i3 = 0; i3 < this.syncs.size(); ++i3) {
                    try {
                        sync3 = (Synchronization)this.syncs.elementAt(i3);
                        sync3.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception ex62) {
                        // empty catch block
                    }
                }
                this.onTxCompletion(true);
                throw throwable;
            }
            for (i3 = 0; i3 < this.interposedSyncs.size(); ++i3) {
                try {
                    sync3 = (Synchronization)this.interposedSyncs.elementAt(i3);
                    sync3.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex62) {
                    // empty catch block
                }
            }
            for (i3 = 0; i3 < this.syncs.size(); ++i3) {
                try {
                    sync3 = (Synchronization)this.syncs.elementAt(i3);
                    sync3.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex62) {
                    // empty catch block
                }
            }
            this.onTxCompletion(true);
            {
                break block40;
                catch (RollbackException ex7) {
                    this.localTxStatus = 4;
                    throw ex7;
                }
                catch (SystemException ex8) {
                    this.localTxStatus = 8;
                    throw ex8;
                }
                catch (Exception ex9) {
                    this.localTxStatus = 4;
                    SystemException exc = new SystemException();
                    exc.initCause((Throwable)ex9);
                    throw exc;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        if (this.isTimerTask) {
            this.cancel();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransaction.rollback, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        try {
            if (this.jtsTx != null) {
                this.jtsTx.rollback();
            } else {
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
            }
        }
        catch (Exception ex) {
            this.localTxStatus = 4;
        }
        finally {
            ((JavaEETransactionManagerSimplified)javaEETM).clearThreadTx();
            if (this.jtsTx == null) {
                for (int i = 0; i < this.syncs.size(); ++i) {
                    try {
                        Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(4);
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            this.onTxCompletion(false);
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransaction.delistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xaRes, flag);
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.deleteresource_for_localtx"));
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransaction.enlistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xaRes);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
        }
        ((JavaEETransactionManagerSimplified)javaEETM).startJTSTx(this);
        return this.jtsTx.enlistResource(xaRes);
    }

    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In JavaEETransaction.registerSynchronization, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(sync);
        } else {
            this.syncs.add(sync);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return status == 1;
    }

    public String toString() {
        return "JavaEETransaction: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setResources(Set resources, String poolName) {
        this.resourceTable.put(poolName, resources);
    }

    public Set getResources(String poolName) {
        return (Set)this.resourceTable.get(poolName);
    }

    public Set getAllParticipatingPools() {
        return this.resourceTable.keySet();
    }

    public void setActiveTxCache(Object cache) {
        this.activeTxCache = cache;
    }

    public Object getActiveTxCache() {
        return this.activeTxCache;
    }

    public int getRemainingTimeout() {
        if (this.timeout == 0) {
            return this.timeout;
        }
        if (this.isTimedOut) {
            return -1;
        }
        return this.timeout - (int)((System.currentTimeMillis() - this.startTime) / 1000L);
    }

    private void longToBytes(long value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 56 & 0xFFL);
        array[offset++] = (byte)(value >>> 48 & 0xFFL);
        array[offset++] = (byte)(value >>> 40 & 0xFFL);
        array[offset++] = (byte)(value >>> 32 & 0xFFL);
        array[offset++] = (byte)(value >>> 24 & 0xFFL);
        array[offset++] = (byte)(value >>> 16 & 0xFFL);
        array[offset++] = (byte)(value >>> 8 & 0xFFL);
        array[offset++] = (byte)(value >>> 0 & 0xFFL);
    }

    static {
        sm = StringManager.getManager(JavaEETransaction.class);
        txIdCounter = 1L;
        isTimerInitialized = false;
        timer = null;
        bqual = new byte[]{0};
    }

    private class JavaEEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        JavaEEXid(long txId) {
            JavaEETransaction.this.longToBytes(txId, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] buff = new char[this.gtrId.length * 2 + 3];
            int pos = 0;
            int globalLen = this.gtrId.length;
            for (int i = 0; i < globalLen; ++i) {
                int currCharHigh = (this.gtrId[i] & 0xF0) >> 4;
                int currCharLow = this.gtrId[i] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            }
            buff[pos++] = 95;
            int currCharHigh = 0;
            int currCharLow = 0;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            this.stringForm = new String(buff);
            return this.stringForm;
        }
    }
}

