/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.appserv.connectors.spi.PoolingException;
import com.sun.appserv.connectors.spi.ResourceHandle;
import com.sun.appserv.connectors.spi.TransactedPoolManager;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.Cache;
import com.sun.enterprise.container.common.spi.ComponentContext;
import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.transaction.JavaEETransaction;
import com.sun.enterprise.transaction.TransactionAdminBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEETransactionManagerSimplified
implements JavaEETransactionManager {
    @Inject
    protected Logger _logger;
    @Inject
    protected TransactedPoolManager poolmgr;
    @Inject
    protected InvocationManager invMgr;
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private ThreadLocal transactions;
    private ThreadLocal localCallCounter;
    private boolean multipleEnlistDelists = false;
    protected int transactionTimeout;
    protected ThreadLocal<Integer> txnTmout = new ThreadLocal();
    protected static Hashtable statusMap = new Hashtable();
    protected Vector activeTransactions = new Vector();
    protected boolean monitoringEnabled = false;
    protected int m_transCommitted = 0;
    protected int m_transRolledback = 0;
    protected int m_transInFlight = 0;
    private Cache resourceTable;
    private static ReentrantReadWriteLock freezeLock = new ReentrantReadWriteLock();

    public JavaEETransactionManagerSimplified() {
        this.init();
        this.transactions = new ThreadLocal();
        this.localCallCounter = new ThreadLocal();
    }

    protected void init() {
        int maxEntries = 8192;
        float loadFactor = 0.75f;
        try {
            float f;
            String loadFactorValue;
            int temp;
            String maxEntriesValue;
            String mEnlistDelists = System.getProperty("ALLOW_MULTIPLE_ENLISTS_DELISTS");
            if ("true".equals(mEnlistDelists)) {
                this.multipleEnlistDelists = true;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "TM: multiple enlists, delists are enabled");
                }
            }
            if ((maxEntriesValue = System.getProperty("JTA_RESOURCE_TABLE_MAX_ENTRIES")) != null && (temp = Integer.parseInt(maxEntriesValue)) > 0) {
                maxEntries = temp;
            }
            if ((loadFactorValue = System.getProperty("JTA_RESOURCE_TABLE_DEFAULT_LOAD_FACTOR")) != null && (f = Float.parseFloat(loadFactorValue)) > 0.0f) {
                loadFactor = f;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Properties cacheProps = null;
        this.resourceTable = new BaseCache();
        ((BaseCache)this.resourceTable).init(maxEntries, loadFactor, cacheProps);
    }

    public void clearThreadTx() {
        this.transactions.set(null);
    }

    public boolean isNullTransaction() {
        return true;
    }

    public void recover(XAResource[] resourceList) {
        throw new UnsupportedOperationException("recover");
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h) throws RollbackException, IllegalStateException, SystemException {
        if (!h.isTransactional()) {
            return true;
        }
        if (h.isEnlistmentSuspended()) {
            return false;
        }
        JavaEETransaction tx = (JavaEETransaction)tran;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "\n\nIn JavaEETransactionManagerSimplified.enlistResource, h=" + h + " h.xares=" + h.getXAResource() + " tx=" + tx);
        }
        if (tx.getNonXAResource() != null) {
            boolean isSameRM = false;
            try {
                isSameRM = h.getXAResource().isSameRM(tx.getNonXAResource().getXAResource());
            }
            catch (XAException xex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", (Object)xex));
            }
            catch (Exception ex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", (Object)ex));
            }
            if (!isSameRM) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
            }
        }
        if (this.monitoringEnabled) {
            // empty if block
        }
        if (h.supportsXA()) {
            if (tx.isLocalTx()) {
                // empty if block
            }
            return this.enlistXAResource((Transaction)tx, h);
        }
        if (tx.isImportedTransaction()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
        }
        if (tx.getNonXAResource() == null) {
            tx.setNonXAResource(h);
        }
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().start(tx.getLocalXid(), 0);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_start_excep"), ex);
            }
            this.poolmgr.resourceEnlisted((Transaction)tx, h);
            return true;
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    public void unregisterComponentResource(ResourceHandle h) {
        Object instance = h.getComponentInstance();
        if (instance == null) {
            return;
        }
        h.setComponentInstance(null);
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        List l = null;
        l = inv != null ? this.getExistingResourceList(instance, inv) : this.getExistingResourceList(instance);
        if (l != null) {
            l.remove(h);
        }
    }

    void startJTSTx(JavaEETransaction tx) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException("startJTSTx");
    }

    public List getResourceList(Object instance, ComponentInvocation inv) {
        if (inv == null) {
            return new ArrayList(0);
        }
        ArrayList l = null;
        if (inv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            Object key = this.getInstanceKey(instance);
            if (key == null) {
                return new ArrayList(0);
            }
            l = (ArrayList)this.resourceTable.get(key);
            if (l == null) {
                l = new ArrayList();
                this.resourceTable.put(key, l);
            }
        }
        return l;
    }

    public void enlistComponentResources() throws RemoteException {
        ComponentInvocation inv;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: enlistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            return;
        }
        try {
            Transaction tran = this.getTransaction();
            inv.setTransaction((Object)tran);
            this.enlistComponentResources(inv);
        }
        catch (InvocationException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException(ex.getMessage(), ex.getNestedException());
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public boolean delistResource(Transaction tran, ResourceHandle h, int flag) throws IllegalStateException, SystemException {
        if (!h.isTransactional()) {
            return true;
        }
        JavaEETransaction tx = (JavaEETransaction)tran;
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().end(tx.getLocalXid(), flag);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_end_excep", (Object)ex));
            }
            return true;
        }
        return this.delistJTSResource(tran, h, flag);
    }

    public void delistComponentResources(boolean suspend) throws RemoteException {
        ComponentInvocation inv;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: delistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            return;
        }
        try {
            this.delistComponentResources(inv, suspend);
        }
        catch (InvocationException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex.getNestedException());
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex);
        }
    }

    public void registerComponentResource(ResourceHandle h) {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null) {
            Object instance = inv.getInstance();
            if (instance == null) {
                return;
            }
            h.setComponentInstance(instance);
            List l = this.getResourceList(instance, inv);
            l.add(h);
        }
    }

    public List getExistingResourceList(Object instance) {
        if (instance == null) {
            return null;
        }
        Object key = this.getInstanceKey(instance);
        if (key == null) {
            return null;
        }
        return (List)this.resourceTable.get(key);
    }

    public List getExistingResourceList(Object instance, ComponentInvocation inv) {
        if (inv == null) {
            return null;
        }
        List l = null;
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            return l;
        }
        Object key = this.getInstanceKey(instance);
        if (key == null) {
            return null;
        }
        return (List)this.resourceTable.get(key);
    }

    public void preInvoke(ComponentInvocation prev) throws InvocationException {
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.delistComponentResources(prev, true);
        }
    }

    public void postInvoke(ComponentInvocation curr, ComponentInvocation prev) throws InvocationException {
        if (curr != null && curr.getTransaction() != null) {
            this.delistComponentResources(curr, false);
        }
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.enlistComponentResources(prev);
        }
    }

    public void componentDestroyed(Object instance) {
        List l;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: componentDestroyed" + instance);
        }
        if ((l = (List)this.resourceTable.get(this.getInstanceKey(instance))) != null && l.size() > 0) {
            this.resourceTable.remove(this.getInstanceKey(instance));
            for (ResourceHandle h : l) {
                try {
                    h.closeUserConnection();
                }
                catch (PoolingException ex) {
                    if (!this._logger.isLoggable(Level.FINE)) continue;
                    this._logger.log(Level.WARNING, "enterprise_distributedtx.pooling_excep", ex);
                }
            }
            l.clear();
        }
    }

    public void ejbDestroyed(ComponentContext context) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, " ejbDestroyed: " + context);
        }
    }

    public boolean isTimedOut() {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null) {
            return tx.isTimedout();
        }
        return false;
    }

    public void checkTransactionImport() {
    }

    public void checkTransactionExport(boolean isLocal) {
    }

    public XATerminator getXATerminator() {
        throw new UnsupportedOperationException("getXATerminator");
    }

    public void release(Xid xid) throws WorkException {
        throw new UnsupportedOperationException("release");
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        throw new UnsupportedOperationException("recreate");
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: registerSynchronization");
        }
        try {
            Transaction tran = this.getTransaction();
            if (tran != null) {
                tran.registerSynchronization(sync);
            }
        }
        catch (RollbackException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.rollbackexcep_in_regsynch", ex);
            throw new IllegalStateException();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.getEffectiveTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(int timeout) throws NotSupportedException, SystemException {
        if (this.transactions.get() != null) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        if (this.getStatus() != 6) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        boolean acquiredlock = false;
        if (this.monitoringEnabled) {
            freezeLock.readLock().lock();
            acquiredlock = true;
        }
        try {
            JavaEETransaction tx = null;
            tx = timeout > 0 ? new JavaEETransaction(timeout) : new JavaEETransaction();
            JavaEETransaction._logger = this._logger;
            JavaEETransaction.javaEETM = this;
            this.transactions.set(tx);
            if (this.monitoringEnabled) {
                this.activeTransactions.addElement(tx);
                ++this.m_transInFlight;
                ComponentInvocation inv = this.invMgr.getCurrentInvocation();
                if (inv != null && inv.getInstance() != null) {
                    tx.setComponentName(inv.getInstance().getClass().getName());
                }
            }
        }
        finally {
            if (acquiredlock) {
                freezeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block17: {
            try {
                JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
                if (tx == null || !tx.isLocalTx()) break block17;
                JavaEETransaction obj = null;
                boolean acquiredlock = false;
                if (this.monitoringEnabled) {
                    obj = tx;
                }
                try {
                    if (this.monitoringEnabled) {
                        freezeLock.readLock().lock();
                        acquiredlock = true;
                    }
                    tx.commit();
                    if (this.monitoringEnabled) {
                        this.monitorTxCompleted(obj, true);
                    }
                }
                catch (RollbackException e) {
                    if (this.monitoringEnabled) {
                        this.monitorTxCompleted(obj, false);
                    }
                    throw e;
                }
                catch (HeuristicRollbackException e) {
                    if (this.monitoringEnabled) {
                        this.monitorTxCompleted(obj, false);
                    }
                    throw e;
                }
                catch (HeuristicMixedException e) {
                    if (this.monitoringEnabled) {
                        this.monitorTxCompleted(obj, true);
                    }
                    throw e;
                }
                finally {
                    if (acquiredlock) {
                        freezeLock.readLock().unlock();
                    }
                }
            }
            finally {
                this.transactions.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        boolean acquiredlock = false;
        try {
            JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
            if (tx != null && tx.isLocalTx()) {
                JavaEETransaction obj = null;
                if (this.monitoringEnabled) {
                    obj = tx;
                }
                if (this.monitoringEnabled) {
                    freezeLock.readLock().lock();
                    acquiredlock = true;
                }
                tx.rollback();
                if (this.monitoringEnabled) {
                    this.monitorTxCompleted(obj, false);
                }
            }
        }
        finally {
            this.transactions.set(null);
            if (acquiredlock) {
                freezeLock.readLock().unlock();
            }
        }
    }

    public int getStatus() throws SystemException {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null) {
            return tx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            boolean acquiredlock = false;
            if (this.monitoringEnabled) {
                freezeLock.readLock().lock();
                acquiredlock = true;
            }
            try {
                tx.setRollbackOnly();
            }
            finally {
                if (acquiredlock) {
                    freezeLock.readLock().unlock();
                }
            }
        }
    }

    public Transaction suspend() throws SystemException {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null) {
            this.transactions.set(null);
            return tx;
        }
        return null;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        JavaEETransaction tx = (JavaEETransaction)this.transactions.get();
        if (tx != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_exist_on_currentThread"));
        }
        if (tobj instanceof JavaEETransaction) {
            JavaEETransaction javaEETx = (JavaEETransaction)tobj;
            this.transactions.set(tobj);
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            seconds = 0;
        }
        this.txnTmout.set(seconds);
    }

    public synchronized void freeze() {
        if (freezeLock.isWriteLocked()) {
            return;
        }
        freezeLock.writeLock().lock();
    }

    public synchronized void unfreeze() {
        if (freezeLock.isWriteLocked()) {
            freezeLock.writeLock().unlock();
        }
    }

    public boolean isFrozen() {
        return freezeLock.isWriteLocked();
    }

    public void cleanTxnTimeout() {
        this.txnTmout.set(null);
    }

    int getEffectiveTimeout() {
        Integer tmout = this.txnTmout.get();
        if (tmout == null) {
            return this.transactionTimeout;
        }
        return tmout;
    }

    public void setDefaultTransactionTimeout(int seconds) {
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }

    public int getNumberOfActiveTransactions() {
        return this.m_transInFlight;
    }

    public ArrayList getActiveTransactions() {
        ArrayList<TransactionAdminBean> tranBeans = new ArrayList<TransactionAdminBean>();
        Vector active = (Vector)this.activeTransactions.clone();
        for (int i = 0; i < active.size(); ++i) {
            try {
                Transaction tran = (Transaction)active.elementAt(i);
                String id = "unknown";
                long startTime = 0L;
                long elapsedTime = 0L;
                String status = "unknown";
                String componentName = "unknown";
                ArrayList<String> resourceNames = null;
                if (tran instanceof JavaEETransaction) {
                    JavaEETransaction tran1 = (JavaEETransaction)tran;
                    id = tran1.getTransactionId();
                    startTime = tran1.getStartTime();
                    componentName = tran1.getComponentName();
                    resourceNames = tran1.getResourceNames();
                }
                elapsedTime = System.currentTimeMillis() - startTime;
                status = (String)statusMap.get(new Integer(tran.getStatus()));
                TransactionAdminBean tBean = new TransactionAdminBean(tran, id, status, elapsedTime, componentName, resourceNames);
                tranBeans.add(tBean);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return tranBeans;
    }

    public int getNumberOfTransactionsRolledBack() {
        return this.m_transRolledback;
    }

    public int getNumberOfTransactionsCommitted() {
        return this.m_transCommitted;
    }

    public void forceRollback(Transaction tran) throws IllegalStateException, SystemException {
        if (tran != null) {
            tran.setRollbackOnly();
        }
    }

    public void setMonitoringEnabled(boolean enabled) {
        this.monitoringEnabled = enabled;
        this.m_transCommitted = 0;
        this.m_transRolledback = 0;
        this.m_transInFlight = 0;
        this.activeTransactions.removeAllElements();
    }

    protected void monitorTxCompleted(Object tran, boolean committed) {
        if (tran == null || !this.activeTransactions.remove(tran)) {
            return;
        }
        if (committed) {
            ++this.m_transCommitted;
        } else {
            ++this.m_transRolledback;
        }
        --this.m_transInFlight;
    }

    protected static String getStatusAsString(int status) {
        return (String)statusMap.get(status);
    }

    private void delistComponentResources(ComponentInvocation inv, boolean suspend) throws InvocationException {
        try {
            Transaction tran = (Transaction)inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                List l = this.getExistingResourceList(inv.getInstance(), inv);
                if (l == null || l.size() == 0) {
                    return;
                }
                int flag = suspend ? 0x2000000 : 0x4000000;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    ResourceHandle h = (ResourceHandle)it.next();
                    try {
                        if (!h.isEnlisted()) continue;
                        this.delistResource(tran, h, flag);
                    }
                    catch (IllegalStateException ex) {
                    }
                    catch (Exception ex) {
                        it.remove();
                        this.handleResourceError(h, ex, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
        }
    }

    protected boolean enlistXAResource(Transaction tran, ResourceHandle h) throws RollbackException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: enlistResource");
        }
        if (h.isTransactional() && (!h.isEnlisted() || !h.isShareable() || this.multipleEnlistDelists)) {
            XAResource res = h.getXAResource();
            boolean result = tran.enlistResource(res);
            if (!h.isEnlisted()) {
                this.poolmgr.resourceEnlisted(tran, h);
            }
            return result;
        }
        return true;
    }

    private void enlistComponentResources(ComponentInvocation inv) throws InvocationException {
        try {
            Transaction tran = (Transaction)inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                List l = this.getExistingResourceList(inv.getInstance(), inv);
                if (l == null || l.size() == 0) {
                    return;
                }
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    ResourceHandle h = (ResourceHandle)it.next();
                    try {
                        this.enlistResource(tran, h);
                    }
                    catch (Exception ex) {
                        it.remove();
                        this.handleResourceError(h, ex, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
        }
    }

    private void handleResourceError(ResourceHandle h, Exception ex, Transaction tran, ComponentInvocation inv) {
        if (this._logger.isLoggable(Level.FINE) && h.isTransactional()) {
            this._logger.log(Level.FINE, "TM: HandleResourceError " + h.getXAResource() + "," + ex);
        }
        try {
            if (tran != null && h.isTransactional() && h.isEnlisted()) {
                tran.delistResource(h.getXAResource(), 0x4000000);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        if (ex instanceof RollbackException) {
            return;
        }
        if (ex instanceof IllegalStateException) {
            try {
                h.closeUserConnection();
            }
            catch (Exception ex2) {}
        } else {
            try {
                h.destroyResource();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    private Object getInstanceKey(Object instance) {
        return instance;
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    private boolean delistJTSResource(Transaction tran, ResourceHandle h, int flag) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: delistResource");
        }
        if (!h.isShareable() || this.multipleEnlistDelists) {
            if (h.isTransactional() && h.isEnlisted()) {
                return tran.delistResource(h.getXAResource(), flag);
            }
            return true;
        }
        return true;
    }

    static {
        statusMap.put(0, "Active");
        statusMap.put(1, "MarkedRollback");
        statusMap.put(2, "Prepared");
        statusMap.put(3, "Committed");
        statusMap.put(4, "RolledBack");
        statusMap.put(5, "UnKnown");
        statusMap.put(6, "NoTransaction");
        statusMap.put(7, "Preparing");
        statusMap.put(8, "Committing");
        statusMap.put(9, "RollingBack");
    }

    private class JTSSynchronization
    implements Synchronization {
        private Transaction jtsTx;
        private JavaEETransactionManagerSimplified javaEETM;

        JTSSynchronization(Transaction jtsTx, JavaEETransactionManagerSimplified javaEETM) {
            this.jtsTx = jtsTx;
            this.javaEETM = javaEETM;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
        }
    }
}

