/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http.listener")
public class DeleteHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttpListener.class);
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="secure", optional=true)
    String secure;
    @Inject
    HttpService httpService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getHttpListener();
                    for (HttpListener listener : list) {
                        if (!listener.getId().equals(DeleteHttpListener.this.listenerId)) continue;
                        list.remove(listener);
                    }
                    return list;
                }
            }, (ConfigBeanProxy)this.httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.fail", "{0} delete failed ", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setMessage(localStrings.getLocalString("delete.http.listener.success", "{0} deleted successfully", new Object[]{this.listenerId}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

