/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.impl.Utils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.common.ActionReporter;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import com.sun.enterprise.v3.common.XMLActionReporter;
import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Adapter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class AdminAdapter
implements Adapter {
    public static final String PREFIX_URI = "/__asadmin";
    public static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(AdminAdapter.class);
    public static final String GFV3 = "gfv3";
    private static final String GET = "GET";
    private static final String POST = "POST";
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    CommandRunner commandRunner;

    public void service(Request req, Response res) throws Exception {
        Utils.getDefaultLogger().finer("Admin adapter !");
        Utils.getDefaultLogger().finer("Received something on " + req.requestURI());
        Utils.getDefaultLogger().finer("QueryString = " + req.queryString());
        ActionReporter report = req.getHeader("User-Agent").startsWith("hk2") ? new PropsFileActionReporter() : (req.getHeader("User-Agent").startsWith("xml") ? new XMLActionReporter() : new HTMLActionReporter());
        this.doCommand(req, report);
        InternalOutputBuffer outputBuffer = (InternalOutputBuffer)res.getOutputBuffer();
        res.setStatus(200);
        res.setContentType(report.getContentType());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        report.writeReport(bos);
        res.setContentLength(bos.size());
        outputBuffer.flush();
        outputBuffer.realWriteBytes(bos.toByteArray(), 0, bos.size());
        res.finish();
    }

    private void doCommand(Request req, ActionReport report) {
        String requestURI = req.requestURI().toString();
        if (!requestURI.startsWith(PREFIX_URI)) {
            String msg = adminStrings.getLocalString("adapter.panic", "Wrong request landed in AdminAdapter {0}", new Object[]{requestURI});
            report.setMessage(msg);
            Utils.getDefaultLogger().info(msg);
            return;
        }
        String command = "";
        if (requestURI.length() > PREFIX_URI.length() + 1) {
            command = requestURI.substring(PREFIX_URI.length() + 1);
        }
        Properties parameters = this.extractParameters(req.queryString().toString());
        try {
            if (req.method().toString().equalsIgnoreCase(GET)) {
                logger.fine("***** AdminAdapter GET  *****");
                this.commandRunner.doCommand(command, parameters, report);
            } else if (req.method().toString().equalsIgnoreCase(POST)) {
                logger.fine("***** AdminAdapter POST *****");
                if (parameters.get("path") != null) {
                    try {
                        String uploadFile = this.doUploadFile(req, report, parameters.getProperty("path"));
                        parameters.setProperty("path", uploadFile);
                        this.commandRunner.doCommand(command, parameters, report);
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, ioe.getMessage());
                    }
                }
            }
        }
        catch (Throwable t) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(t);
            report.setMessage(t.getLocalizedMessage());
            report.setActionDescription("Last-chance AdminAdapter exception handler");
        }
    }

    public void afterService(Request req, Response res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    public String getContextRoot() {
        return PREFIX_URI;
    }

    private String doUploadFile(Request req, ActionReport report, String fileName) throws IOException {
        String localTmpDir = System.getProperty("java.io.tmpdir");
        File gfv3Folder = new File(localTmpDir, GFV3);
        File uploadFile = null;
        FileOutputStream fos = null;
        String uploadFilePath = null;
        try {
            if (!gfv3Folder.exists()) {
                gfv3Folder.mkdirs();
            }
            if ((uploadFile = new File(gfv3Folder, fileName)).exists() && !uploadFile.delete()) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("cannot delete existing file: " + uploadFile);
                throw new IOException("cannot delete existing file: " + uploadFile);
            }
            uploadFilePath = uploadFile.getCanonicalPath();
            fos = new FileOutputStream(uploadFile);
            ByteChunk bc = new ByteChunk(65536);
            InputBuffer ib = req.getInputBuffer();
            int ii = req.doRead(bc);
            while (ii > 0) {
                fos.write(bc.getBytes(), bc.getOffset(), ii);
                ii = req.doRead(bc);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage("upload file successful: " + uploadFilePath);
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("upload file failed: " + uploadFilePath);
            report.setFailureCause((Throwable)e);
            throw new IOException("upload file failed: " + uploadFilePath);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return uploadFilePath;
    }

    Properties extractParameters(String requestString) {
        Properties parameters = new Properties();
        StringTokenizer stoken = new StringTokenizer(requestString, "?");
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf("=") == -1) continue;
            String paramName = token.substring(0, token.lastIndexOf("="));
            String value = token.substring(token.lastIndexOf("=") + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.WARNING, adminStrings.getLocalString("adapter.param.decode", "Cannot decode parameter {0} = {1}"));
            }
            parameters.setProperty(paramName, value);
        }
        if (logger.isLoggable(Level.FINER)) {
            for (Object key : parameters.keySet()) {
                logger.finer("Key " + key + " = " + parameters.getProperty((String)key));
            }
        }
        return parameters;
    }
}

