/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JDBCResourceManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.resource")
public class CreateJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcResource.class);
    @Param(name="connectionpoolid")
    String connectionPoolId;
    @Param(optional=true)
    String enabled = Boolean.TRUE.toString();
    @Param(optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        JDBCResourceManager jdbcMgr = new JDBCResourceManager();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("jndi-name", this.jndiName);
        attrList.put("pool-name", this.connectionPoolId);
        attrList.put("description", this.description);
        attrList.put("enabled", this.enabled);
        try {
            rs = jdbcMgr.create(this.resources, attrList, this.properties, this.jndiName);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jdbc.resource.failed", "JDBC resource {0} creation failed", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == ResourceStatus.FAILURE) {
            ec = ActionReport.ExitCode.FAILURE;
            report.setMessage(localStrings.getLocalString("create.jdbc.resource.failed", "JDBC resource {0} creation failed", new Object[]{this.jndiName}));
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        } else {
            report.setMessage(localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName}));
        }
        report.setActionExitCode(ec);
    }
}

