/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-profiler")
@Scoped(value=PerLookup.class)
@I18n(value="create.profiler")
public class CreateProfiler
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateProfiler.class);
    @Param(optional=true)
    String classpath;
    @Param(optional=true)
    String enabled = Boolean.TRUE.toString();
    @Param(name="nativelibrarypath", optional=true)
    String nativeLibraryPath;
    @Param(name="profiler_name", primary=true)
    String name;
    @Param(optional=true)
    String property;
    @Param(optional=true)
    String target;
    @Inject
    JavaConfig javaConfig;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

                public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                    Profiler newProfiler = (Profiler)ConfigSupport.createChildOf((Object)param, Profiler.class);
                    newProfiler.setName(CreateProfiler.this.name);
                    newProfiler.setClasspath(CreateProfiler.this.classpath);
                    newProfiler.setEnabled(CreateProfiler.this.enabled);
                    newProfiler.setNativeLibraryPath(CreateProfiler.this.nativeLibraryPath);
                    param.setProfiler(newProfiler);
                    return newProfiler;
                }
            }, (ConfigBeanProxy)this.javaConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.profiler.fail", "{0} create failed ", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("create.profiler.success", "Profiler {0} created successfully", new Object[]{this.name}));
    }
}

