/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.ResourceManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@I18n(value="jdbc.resource.manager")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private static final String DESCRIPTION = "description";
    String jndiName = null;
    String description = null;
    String poolName = null;
    String enabled = Boolean.TRUE.toString();

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, String tgtName) throws Exception {
        this.jndiName = (String)attrList.get("jndi-name");
        this.description = (String)attrList.get(DESCRIPTION);
        this.poolName = (String)attrList.get("pool-name");
        this.enabled = (String)attrList.get("enabled");
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg = localStrings.getLocalString("create.jdbc.resource", "A JDBC resource named {0} already exists.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcResource newResource = (JdbcResource)ConfigSupport.createChildOf((Object)param, JdbcResource.class);
                    newResource.setJndiName(JDBCResourceManager.this.jndiName);
                    if (JDBCResourceManager.this.description != null) {
                        newResource.setDescription(JDBCResourceManager.this.description);
                    }
                    newResource.setPoolName(JDBCResourceManager.this.poolName);
                    newResource.setEnabled(JDBCResourceManager.this.enabled);
                    for (Map.Entry<Object, Object> e : props.entrySet()) {
                        Property prop = (Property)ConfigSupport.createChildOf((Object)newResource, Property.class);
                        prop.setName((String)e.getKey());
                        prop.setValue((String)e.getValue());
                        newResource.getProperty().add(prop);
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            status.setException(tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        ResourceStatus status = new ResourceStatus(ResourceStatus.SUCCESS, msg);
        return status;
    }

    public ResourceStatus delete(Resources resources, final JdbcResource[] jdbcResources, final String jndiName) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        if (!this.isResourceExists(resources, jndiName)) {
            String msg = localStrings.getLocalString("jdbc.resource.resourceDoesNotExist", "A JDBC resource named {0} does not exits.", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcResource resource : jdbcResources) {
                        if (!resource.getJndiName().equals(jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
                ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
                return status;
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            status.setException(tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbc.resource.deleteSuccess", "JDBC resource {0} deleted successfully", new Object[]{jndiName});
        ResourceStatus status = new ResourceStatus(ResourceStatus.SUCCESS, msg);
        return status;
    }

    public ArrayList list(JdbcResource[] jdbcResources) {
        ArrayList<String> list = new ArrayList<String>();
        for (JdbcResource r : jdbcResources) {
            list.add(r.getJndiName());
        }
        return list;
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

