/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ContainerInfo;
import com.sun.enterprise.v3.data.ContainerRegistry;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-applications")
public class ListApplicationsCommand
implements AdminCommand {
    @Inject
    ContainerRegistry containerRegistry;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription("List of Deployed Applications");
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        StringBuffer buffer = new StringBuffer();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage("List of deployed applications per container");
        part.setChildrenType("ContractProvider");
        for (ContainerInfo containerInfo : this.containerRegistry.getContainers()) {
            ActionReport.MessagePart containerChild = part.addChild();
            containerChild.setMessage(containerInfo.getSniffer().getModuleType() + " ContractProvider");
            Module connectorModule = containerInfo.getMainModule();
            containerChild.addProperty("Connector module", connectorModule.getModuleDefinition().getName());
            containerChild.addProperty("Sniffer module", containerInfo.getSniffer().getClass().toString());
            containerChild.setChildrenType("Application");
            Iterable<ApplicationInfo> apps = containerInfo.getApplications();
            for (ApplicationInfo info : apps) {
                ActionReport.MessagePart appPart = containerChild.addChild();
                appPart.setMessage(info.getName());
                appPart.getProps().put("Source", info.getSource().getURI());
            }
        }
    }
}

