/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.ServerEnvironment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.config.support.ConfigurationPersistence;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

@Service
@Scoped(value=Singleton.class)
public class DomainXmlPersistence
implements ConfigurationPersistence {
    @Inject
    ServerEnvironment env;
    @Inject
    Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(DomDocument doc) throws IOException {
        File destination = new File(this.env.getConfigDirPath(), "domain.xml");
        File f = File.createTempFile("domain", ".xml", destination.getParentFile());
        if (f == null) {
            throw new IOException("Cannot create temporary file when saving domain.xml");
        }
        XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        FileOutputStream fos = new FileOutputStream(f);
        try {
            writer = xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos));
            IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
            doc.writeTo((XMLStreamWriter)indentingXMLStreamWriter);
            indentingXMLStreamWriter.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File backup = new File(this.env.getConfigDirPath(), "domain.bak");
        if (backup.exists() && !backup.delete()) {
            this.logger.severe("Could not delete previous backup file at " + backup.getAbsolutePath());
            return;
        }
        if (!destination.renameTo(backup)) {
            this.logger.severe("Could not rename " + destination.getAbsolutePath() + " to " + backup.getAbsolutePath());
            return;
        }
        if (!f.renameTo(destination)) {
            this.logger.severe("Could not rename " + f.getAbsolutePath() + " to " + destination.getAbsolutePath());
            if (!backup.renameTo(destination)) {
                this.logger.severe("Could not rename backup to" + destination.getAbsolutePath());
            }
        }
    }
}

