/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ContainerInfo;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.ServerEnvironment;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
@Async
public class ApplicationLoaderService
extends ApplicationLifecycle
implements Startup,
PreDestroy,
PostConstruct {
    @Inject
    GrizzlyService adapter;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    Server server;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        File sourceFile;
        assert (this.env != null);
        block5: for (Module module : this.applications.getModules()) {
            if (!(module instanceof Application)) continue;
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (!appRef.getRef().equals(module.getName())) continue;
                if (!appRef.getEnabled().equals(String.valueOf(Boolean.TRUE))) continue block5;
                this.processApplication((Application)module, this.logger);
                continue block5;
            }
        }
        String defaultParam = (String)this.env.getStartupContext().getArguments().get("default");
        if (defaultParam != null && (sourceFile = defaultParam.equals(".") ? new File(System.getProperty("user.dir")) : new File(defaultParam)).exists()) {
            sourceFile = sourceFile.getAbsoluteFile();
            try {
                ReadableArchive sourceArchive = null;
                try {
                    Collection<Sniffer> appSniffers;
                    sourceArchive = this.archiveFactory.openArchive(sourceFile);
                    ArchiveHandler handler = this.getArchiveHandler(sourceArchive);
                    ClassLoader cloader = null;
                    if (handler != null) {
                        cloader = handler.getClassLoader(null, sourceArchive);
                    }
                    if ((appSniffers = this.getSniffers(sourceArchive, cloader)) != null) {
                        Properties deploymentProperties = new Properties();
                        deploymentProperties.setProperty("name", sourceFile.getName());
                        DeploymentContextImpl depContext = new DeploymentContextImpl(this.logger, sourceArchive, deploymentProperties, this.env);
                        depContext.setClassLoader(cloader);
                        HTMLActionReporter report = new HTMLActionReporter();
                        this.deploy(appSniffers, depContext, report);
                    } else {
                        this.logger.severe("Cannot find the application type for the artifact at : " + sourceFile.getAbsolutePath());
                        this.logger.severe("Was the container or sniffer removed ?");
                    }
                }
                finally {
                    if (sourceArchive != null) {
                        sourceArchive.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "IOException while opening deployed artifact", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApplication(Application app, Logger logger) {
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        String source = app.getLocation();
        String appName = app.getName();
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Engine engine : app.getEngine()) {
            snifferTypes.add(engine.getSniffer());
        }
        if (snifferTypes.isEmpty()) {
            logger.severe("Cannot determine application type at " + source);
            return;
        }
        URI uri = null;
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            logger.severe("Cannot determine original location for application : " + e.getMessage());
        }
        File sourceFile = new File(uri);
        if (sourceFile.exists()) {
            try {
                ReadableArchive archive = null;
                try {
                    archive = this.archiveFactory.openArchive(sourceFile);
                    Properties deploymentParams = this.populateDeployParamsFromDomainXML(app);
                    DeploymentContextImpl depContext = new DeploymentContextImpl(logger, archive, deploymentParams, this.env);
                    depContext.setProps(this.populateDeployPropsFromDomainXML(app));
                    HTMLActionReporter report = new HTMLActionReporter();
                    ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                    for (String snifferType : snifferTypes) {
                        Sniffer sniffer = this.getSniffer(snifferType);
                        if (sniffer != null) {
                            sniffers.add(sniffer);
                            continue;
                        }
                        logger.severe("Cannot find sniffer for module type : " + snifferType);
                    }
                    if (sniffers.isEmpty()) {
                        logger.severe("Cannot find any sniffer for deployed app " + appName);
                        return;
                    }
                    this.deploy(sniffers, depContext, report);
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info("Loading " + appName + " Application done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                    } else {
                        logger.severe(report.getMessage());
                    }
                }
                finally {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.FINE, e.getMessage(), e);
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException while opening deployed artifact", e);
            }
        } else {
            logger.severe("Application previously deployed is not at its original location any more : " + source);
        }
    }

    protected <T extends Container, U extends ApplicationContainer> Deployer getDeployer(ContainerInfo<T, U> containerInfo) {
        final Deployer<T, U> deployer = containerInfo.getDeployer();
        assert (deployer != null);
        return new Deployer<T, U>(){

            public boolean prepare(DeploymentContext context) {
                return true;
            }

            public U load(T container, DeploymentContext context) {
                return deployer.load(container, context);
            }

            public void unload(U appContainer, DeploymentContext context) {
                deployer.unload(appContainer, context);
            }

            public void clean(DeploymentContext context) {
            }

            public MetaData getMetaData() {
                return deployer.getMetaData();
            }
        };
    }

    public String toString() {
        return "Application Loader";
    }

    public void preDestroy() {
        Properties props = new Properties();
        HTMLActionReporter dummy = new HTMLActionReporter();
        for (ContainerInfo containerInfo : this.containerRegistry.getContainers()) {
            Deployer deployer = this.getDeployer(containerInfo);
            if (deployer == null) continue;
            Iterable<ApplicationInfo> apps = containerInfo.getApplications();
            for (ApplicationInfo appInfo : apps) {
                props.put("name", appInfo.getName());
                DeploymentContextImpl depContext = new DeploymentContextImpl(this.logger, appInfo.getSource(), props, this.env);
                super.unload(appInfo.getName(), depContext, dummy);
            }
        }
    }
}

