/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.v3.server.ServerEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class CmdLineParamProcessor
implements Init,
PostConstruct {
    @Inject
    ServerEnvironment env;
    @Inject
    ModulesRegistry registry;
    @Inject
    Logger logger;

    public void postConstruct() {
        String lib = (String)this.env.getStartupContext().getArguments().get("-gflib");
        if (lib == null) {
            return;
        }
        File f = new File(lib);
        if (!f.isAbsolute()) {
            f = new File(System.getProperty("user.dir"), lib);
        }
        if (!f.exists()) {
            this.logger.severe("File not found : " + f.getAbsolutePath());
        }
        try {
            DefaultModuleDefinition moduleDef = new DefaultModuleDefinition(f);
            this.registry.add((ModuleDefinition)moduleDef);
            this.logger.fine("Succesfully added library to module subsystem " + moduleDef.getName());
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Exception with provided library : " + f.getName(), ioe);
        }
    }
}

