/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.QueryWrapper;
import com.sun.enterprise.container.common.spi.JavaEEContainer;
import com.sun.enterprise.container.common.spi.JavaEETransaction;
import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.ContainerUtil;
import com.sun.enterprise.container.common.spi.util.EntityManagerMethod;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerWrapper
implements EntityManager,
Serializable {
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.util");
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private transient EntityManagerFactory entityManagerFactory;
    private transient JavaEETransactionManager txManager;
    private transient ContainerUtil containerUtil;
    private transient InvocationManager invMgr;
    private transient EntityManager extendedEntityManager;
    private transient EntityManager nonTxEntityManager;
    private transient ComponentEnvManager compEnvMgr;

    public EntityManagerWrapper(String unitName, PersistenceContextType contextType, InvocationManager invMgr, ComponentEnvManager compEnvMgr, Map emProperties) {
        this.unitName = unitName;
        this.contextType = contextType;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
        this.emProperties = emProperties;
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        JavaEETransaction tx = null;
        try {
            tx = (JavaEETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
        if (tx == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        EntityManager delegate = null;
        if (this.nonTxEntityManager != null) {
            this.cleanupNonTxEntityManager();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            JavaEETransaction tx = null;
            try {
                tx = (JavaEETransaction)this.txManager.getTransaction();
            }
            catch (Exception e) {
                throw new IllegalStateException("exception retrieving tx", e);
            }
            if (tx != null) {
                delegate = tx.getExtendedEntityManager(this.entityManagerFactory);
                if (delegate == null && (delegate = tx.getTxEntityManager(this.entityManagerFactory)) == null) {
                    delegate = this.entityManagerFactory.createEntityManager(this.emProperties);
                    tx.addTxEntityManagerMapping(this.entityManagerFactory, delegate);
                }
            } else {
                delegate = this.nonTxEntityManager = this.entityManagerFactory.createEntityManager(this.emProperties);
            }
        } else {
            Object cc;
            InvocationManager invMgr;
            ComponentInvocation ci;
            if (this.extendedEntityManager == null && (ci = (invMgr = this.containerUtil.getInvocationManager()).getCurrentInvocation()) != null && (cc = ci.getContainer()) instanceof JavaEEContainer) {
                this.extendedEntityManager = ((JavaEEContainer)cc).lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("In EntityManagerWrapper::_getDelegate(). Logical entity manager  = " + this);
            _logger.fine("Physical entity manager = " + delegate);
        }
        return delegate;
    }

    private void cleanupNonTxEntityManager() {
        if (this.nonTxEntityManager != null) {
            this.nonTxEntityManager.close();
            this.nonTxEntityManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.MERGE);
            }
            Object object = this._getDelegate().merge(entity);
            return (T)object;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.doTxRequiredCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, ejbqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNamedQuery(String name) {
        Query returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNamedQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, name);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultClass);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultSetMapping);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
        }
        finally {
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            return bl;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    public void close() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        if (agent.isEnabled()) {
            agent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            agent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        if (agent.isEnabled()) {
            agent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            agent.entityManagerMethodEnd();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            return entityManager;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.nonTxEntityManager = null;
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        try {
            if (agent.isEnabled()) {
                agent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (agent.isEnabled()) {
                agent.entityManagerMethodEnd();
            }
        }
    }

    public void joinTransaction() {
        this.doTxRequiredCheck();
        CallFlowAgent agent = this.containerUtil.getCallFlowAgent();
        if (agent.isEnabled()) {
            agent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            agent.entityManagerMethodEnd();
        }
    }
}

