/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniXmlParser {
    private File domainXml;
    private XMLStreamReader parser;
    private String serverName;
    private String configRef;
    private List<String> jvmOptions = new ArrayList<String>();
    private List<String> profilerJvmOptions = new ArrayList<String>();
    private Map<String, String> javaConfig;
    private Map<String, String> profilerConfig = Collections.emptyMap();
    private Map<String, String> sysProps = new HashMap<String, String>();
    private Map<String, String> profilerSysProps = new HashMap<String, String>();
    private boolean valid = false;
    private Set<Integer> adminPorts = new HashSet<Integer>();
    private String domainName;
    private static LocalStringsImpl strings = new LocalStringsImpl(MiniXmlParser.class);

    public MiniXmlParser(File domainXml) throws MiniXmlParserException {
        this(domainXml, "server");
    }

    public MiniXmlParser(File domainXml, String serverName) throws MiniXmlParserException {
        this.serverName = serverName;
        this.domainXml = domainXml;
        try {
            this.read();
            this.valid = true;
        }
        catch (EndDocumentException e) {
            throw new MiniXmlParserException(strings.get("enddocument", this.configRef, serverName));
        }
        catch (Exception e) {
            String msg = strings.get("toplevel", e);
            throw new MiniXmlParserException(e);
        }
    }

    public Map<String, String> getJavaConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.javaConfig;
    }

    public List<String> getJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.jvmOptions;
    }

    public Map<String, String> getProfilerConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerConfig;
    }

    public List<String> getProfilerJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerJvmOptions;
    }

    public Map<String, String> getProfilerSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerSysProps;
    }

    public Map<String, String> getSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.sysProps;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Set<Integer> getAdminPorts() {
        return this.adminPorts;
    }

    private void read() throws XMLStreamException, EndDocumentException, FileNotFoundException {
        this.createParser();
        this.getConfigRefName();
        try {
            this.getConfig();
            this.findDomainName();
        }
        catch (EndDocumentException ex) {
            this.createParser();
            this.skipRoot("domain");
            this.getConfig();
            this.findDomainName();
            Logger.getLogger(MiniXmlParser.class.getName()).log(Level.WARNING, strings.get("secondpass"));
        }
    }

    private void createParser() throws FileNotFoundException, XMLStreamException {
        FileInputStream stream = new FileInputStream(this.domainXml);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        this.parser = xif.createXMLStreamReader(this.domainXml.toURI().toString(), stream);
    }

    private void getConfigRefName() throws XMLStreamException, EndDocumentException {
        Map<String, String> map;
        String thisName;
        if (this.configRef != null) {
            return;
        }
        this.skipRoot("domain");
        while (true) {
            this.skipTo("servers", "property");
            String name = this.parser.getLocalName();
            if (name.equals("servers")) break;
            this.parseDomainName();
        }
        do {
            this.skipNonStartElements();
            if (this.parser.getLocalName().equals("server")) continue;
            throw new XMLStreamException("no server found");
        } while (!this.serverName.equals(thisName = (map = this.parseAttributes()).get("name")));
        this.configRef = map.get("config-ref");
        this.parseSysPropsFromServer();
        this.skipToEnd("servers");
    }

    private void getConfig() throws XMLStreamException, EndDocumentException {
        Map<String, String> map;
        String thisName;
        while (true) {
            this.skipTo("configs", "property");
            String name = this.parser.getLocalName();
            if (name.equals("configs")) break;
            this.parseDomainName();
        }
        do {
            this.skipTo("config");
        } while (!this.configRef.equals(thisName = (map = this.parseAttributes()).get("name")));
        this.parseConfig();
    }

    private void parseConfig() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!this.parser.getLocalName().equals("config")) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if (name.equals("system-property")) {
                this.parseSystemPropertyNoOverride();
                continue;
            }
            if (name.equals("java-config")) {
                this.parseJavaConfig();
                continue;
            }
            if (name.equals("http-service")) {
                this.parseHttpService();
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSysPropsFromServer() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!this.parser.getLocalName().equals("server")) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if (name.equals("system-property")) {
                this.parseSystemPropertyWithOverride();
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSystemPropertyNoOverride() {
        this.parseSystemProperty(false);
    }

    private void parseSystemPropertyWithOverride() {
        this.parseSystemProperty(true);
    }

    private void parseSystemProperty(boolean override) {
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name != null && (override || !this.sysProps.containsKey(name))) {
            this.sysProps.put(name, value);
        }
    }

    private void parseJavaConfig() throws XMLStreamException, EndDocumentException {
        this.javaConfig = this.parseAttributes();
        this.parseJvmAndProfilerOptions();
    }

    private void parseJvmAndProfilerOptions() throws XMLStreamException, EndDocumentException {
        while (this.skipToButNotPast("java-config", "jvm-options", "profiler")) {
            if (this.parser.getLocalName().equals("jvm-options")) {
                this.jvmOptions.add(this.parser.getElementText());
                continue;
            }
            this.parseProfiler();
        }
    }

    private void parseProfiler() throws XMLStreamException, EndDocumentException {
        this.profilerConfig = this.parseAttributes();
        while (this.skipToButNotPast("profiler", "jvm-options", "property")) {
            if (this.parser.getLocalName().equals("jvm-options")) {
                this.profilerJvmOptions.add(this.parser.getElementText());
                continue;
            }
            this.parseProperty(this.profilerSysProps);
        }
    }

    private void parseProperty(Map<String, String> map) throws XMLStreamException, EndDocumentException {
        Map<String, String> prop = this.parseAttributes();
        String name = prop.get("name");
        String value = prop.get("value");
        if (name != null) {
            map.put(name, value);
        }
    }

    private void skipNonStartElements() throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
    }

    private void skipRoot(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
        if (!name.equals(this.parser.getLocalName())) {
            throw new XMLStreamException("Unknown Domain XML Layout");
        }
    }

    private void skipTo(String name) throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (name.equals(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    private void skipTo(String name1, String name2) throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (name1.equals(localName) || name2.equals(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    private boolean skipToButNotPast(String endName, String ... startNames) throws XMLStreamException, EndDocumentException {
        int event;
        do {
            if ((event = this.next()) != 1) continue;
            for (String s : startNames) {
                if (!this.parser.getLocalName().equals(s)) continue;
                return true;
            }
        } while (event != 2 || !this.parser.getLocalName().equals(endName));
        return false;
    }

    private void skipTree(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private void skipToEnd(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private int next() throws XMLStreamException, EndDocumentException {
        int event = this.parser.next();
        if (event == 8) {
            this.parser.close();
            throw new EndDocumentException();
        }
        return event;
    }

    private void dump() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        System.out.println(sb.toString());
    }

    private void findDomainName() throws XMLStreamException {
        try {
            while (this.domainName == null) {
                this.skipTo("property");
                this.parseDomainName();
            }
        }
        catch (EndDocumentException endDocumentException) {
            // empty catch block
        }
    }

    private void parseDomainName() {
        if (this.domainName != null) {
            return;
        }
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name == null || value == null) {
            return;
        }
        if (name.equals("administrative.domain.name")) {
            this.domainName = value;
        }
    }

    private void parseHttpService() throws XMLStreamException, EndDocumentException {
        ArrayList<Map<String, String>> listenerAttributes = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> vsAttributes = new ArrayList<Map<String, String>>();
        while (true) {
            this.skipToButNotPast("http-service", "http-listener", "virtual-server");
            String name = this.parser.getLocalName();
            if (name.equals("http-listener")) {
                listenerAttributes.add(this.parseAttributes());
                continue;
            }
            if (name.equals("virtual-server")) {
                vsAttributes.add(this.parseAttributes());
                continue;
            }
            if (name.equals("http-service")) break;
        }
        String[] listenerNames = this.getListenerNamesForVS("__asadmin", vsAttributes);
        if (listenerNames == null || listenerNames.length <= 0) {
            return;
        }
        this.addPortsForListeners(listenerAttributes, listenerNames);
    }

    private String[] getListenerNamesForVS(String vsid, List<Map<String, String>> vsAttributes) {
        String listeners = null;
        String[] listenerArray = null;
        for (Map<String, String> atts : vsAttributes) {
            String id = atts.get("id");
            if (id == null || !id.equals(vsid)) continue;
            listeners = atts.get("http-listeners");
            break;
        }
        if (GFLauncherUtils.ok(listeners) && (listenerArray = listeners.split(",")) != null && listenerArray.length <= 0) {
            listenerArray = null;
        }
        if (listenerArray == null) {
            listenerArray = new String[]{};
        }
        return listenerArray;
    }

    private void addPortsForListeners(List<Map<String, String>> listenerAttributes, String[] listenerNames) {
        block0: for (Map<String, String> atts : listenerAttributes) {
            String id = atts.get("id");
            String port = atts.get("port");
            String vs = atts.get("default-virtual-server");
            if (id == null) continue;
            for (String listenerName : listenerNames) {
                if (!id.equals(listenerName)) continue;
                this.addPort(port);
                continue block0;
            }
        }
    }

    private void addPort(String portString) {
        try {
            int port = Integer.parseInt(portString);
            this.adminPorts.add(port);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, String> parseAttributes() {
        int num = this.parser.getAttributeCount();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            map.put(this.parser.getAttributeName(i).getLocalPart(), this.parser.getAttributeValue(i));
        }
        return map;
    }

    private static class EndDocumentException
    extends Exception {
        EndDocumentException() {
        }
    }
}

