/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.portunif.FilterChainProtocolHandler;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.portunif.ProtocolFinder;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.portunif.ProtocolRequestWorkerThreadAdapter;
import com.sun.grizzly.portunif.SSLFilterChainProtocolHandler;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PUReadFilter
extends ReadFilter {
    public static final long DEFAULT_READ_TIMEOUT = 1000L;
    public static final String PROTOCOL_FINDERS = "com.sun.grizzly.portunif.protocolFinders";
    public static final String PROTOCOL_HANDLERS = "com.sun.grizzly.portunif.protocolHandlers";
    public static final String PU_PRE_PROCESSORS = "com.sun.grizzly.portunif.PUPreProcessors";
    private static final int MAX_FIND_TRIES = 2;
    private static final ProtocolHandler filterChainProtocolHandler = new FilterChainProtocolHandler();
    private static final ProtocolHandler sslFilterChainProtocolHandler = new SSLFilterChainProtocolHandler();
    private ConcurrentHashMap<String, ProtocolHandler> protocolHandlers = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<ProtocolFinder> protocolFinders = new ConcurrentLinkedQueue();
    private volatile Map<SelectionKey, ProtocolHandler> mappedProtocols = PUReadFilter.createMappedProtocolsMap();
    private List<PUPreProcessor> preProcessors;
    private long readTimeout = 1000L;
    private static Logger logger = Controller.logger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws IOException {
        block32: {
            SelectionKey selectionKey = context.getSelectionKey();
            ProtocolHandler protocolHandler = null;
            if (this.mappedProtocols != null) {
                protocolHandler = this.mappedProtocols.get(selectionKey);
            }
            ProtocolRequestWorkerThreadAdapter protocolRequest = new ProtocolRequestWorkerThreadAdapter();
            protocolRequest.setContext(context);
            int readTry = 0;
            try {
                ByteBuffer readBuffer;
                ByteBuffer byteBuffer = readBuffer = protocolHandler != null ? protocolHandler.getByteBuffer() : protocolRequest.getByteBuffer();
                if (!super.execute(context, readBuffer)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "PUReadFilter. Read failed");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (protocolHandler == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "PUReadFilter. Finding protocol...");
                    }
                    while (readTry++ < 2) {
                        String protocolName = null;
                        if (this.preProcessors != null) {
                            for (PUPreProcessor preProcessor : this.preProcessors) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "PUReadFilter. Apply preprocessor process: " + preProcessor);
                                }
                                if (!preProcessor.process(context, protocolRequest)) continue;
                                protocolRequest.addPassedPreProcessor(preProcessor.getId());
                            }
                        }
                        try {
                            protocolName = this.findProtocol(context, protocolRequest);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "PUReadFilter. Found protocol: " + protocolName);
                            }
                        }
                        catch (IOException e) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "PUReadFilter. IOException during protocol finding:", e);
                            }
                            this.exceptionKey(context, e);
                            boolean preProcessor = false;
                            if (readTry == 2) {
                                this.cancelKey(context);
                            }
                            protocolHandler = null;
                            return preProcessor;
                        }
                        if (protocolName != null) {
                            protocolRequest.setProtocolName(protocolName);
                            protocolHandler = this.protocolHandlers.get(protocolName);
                            if (protocolHandler != null) {
                                boolean e = this.processProtocolHandler(protocolHandler, context, protocolRequest, true);
                                return e;
                            }
                            this.mapSelectionKey(selectionKey, this.getProtocolChainHandler(context, protocolRequest));
                            boolean e = true;
                            return e;
                        }
                        if (this.preProcessors != null && protocolRequest.getPassedPreProcessors() != null) {
                            Collection<String> passedPreProcessors = protocolRequest.getPassedPreProcessors();
                            for (int i = this.preProcessors.size() - 1; i >= 0; --i) {
                                PUPreProcessor preProcessor = this.preProcessors.get(i);
                                if (!passedPreProcessors.contains(preProcessor.getId())) continue;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "PUReadFilter. Apply preprocessor POSTProcess: " + preProcessor);
                                }
                                preProcessor.postProcess(context, protocolRequest);
                            }
                        }
                        int bytesRead = Utils.readWithTemporarySelector((SelectableChannel)selectionKey.channel(), (ByteBuffer)protocolRequest.getByteBuffer(), (long)this.readTimeout);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "PUReadFilter. Read more bytes: " + bytesRead);
                        }
                        if (bytesRead > 0) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block32;
                }
                boolean bl = this.processProtocolHandler(protocolHandler, context, protocolRequest, false);
                return bl;
            }
            catch (Throwable ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PortUnification exception", ex);
                }
                this.cancelKey(context);
                boolean bl = false;
                return bl;
            }
            finally {
                if (readTry == 2) {
                    this.cancelKey(context);
                }
                protocolHandler = null;
            }
        }
        return true;
    }

    protected ProtocolHandler getProtocolChainHandler(Context context, PUProtocolRequest protocolRequest) {
        if (protocolRequest.getSSLEngine() != null) {
            return sslFilterChainProtocolHandler;
        }
        return filterChainProtocolHandler;
    }

    public boolean processProtocolHandler(ProtocolHandler protocolHandler, Context context, PUProtocolRequest protocolRequest, boolean mapSelectionKey) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PUReadFilter. Process request with handler: " + protocolHandler);
        }
        boolean isKeepAlive = protocolHandler.handle(context, protocolRequest);
        if (protocolRequest.isExecuteFilterChain()) {
            return true;
        }
        if (isKeepAlive) {
            if (mapSelectionKey) {
                this.mapSelectionKey(context.getSelectionKey(), protocolHandler);
            }
            this.reRegisterKey(context);
        } else {
            this.cancelKey(context);
        }
        return false;
    }

    private void exceptionKey(Context context, Exception e) {
        context.setAttribute("succes_read", (Object)Boolean.FALSE);
        context.setAttribute("throwable", (Object)e);
        this.cancelKey(context);
    }

    private void cancelKey(Context context) {
        context.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
    }

    private void reRegisterKey(Context context) {
        context.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
    }

    private static List loadPUArtifacts(String enumeration) {
        if (enumeration != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(enumeration), ",");
            ArrayList<Object> result = new ArrayList<Object>(4);
            while (st.hasMoreTokens()) {
                Object artifact = PUReadFilter.loadInstance(st.nextToken());
                if (artifact == null) continue;
                result.add(artifact);
            }
            return result;
        }
        return null;
    }

    private static Object loadInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return clazz.newInstance();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error initializing class: " + className, e);
            return null;
        }
    }

    public void configure(Properties props) {
        List protocolFinders = PUReadFilter.loadPUArtifacts(props.getProperty(PROTOCOL_FINDERS));
        List protocolHandlers = PUReadFilter.loadPUArtifacts(props.getProperty(PROTOCOL_HANDLERS));
        List puPreProcessors = PUReadFilter.loadPUArtifacts(props.getProperty(PU_PRE_PROCESSORS));
        this.configure(protocolFinders, protocolHandlers, puPreProcessors);
    }

    public void configure(List<ProtocolFinder> protocolFinders, List<ProtocolHandler> protocolHandlers, List<PUPreProcessor> preProcessors) {
        this.protocolFinders.clear();
        this.protocolHandlers.clear();
        if (protocolFinders != null) {
            for (ProtocolFinder protocolFinder : protocolFinders) {
                this.addProtocolFinder(protocolFinder);
            }
        }
        if (protocolHandlers != null) {
            for (ProtocolHandler protocolHandler : protocolHandlers) {
                this.addProtocolHandler(protocolHandler);
            }
        }
        if (preProcessors != null) {
            if (this.preProcessors != null) {
                this.preProcessors.clear();
            }
            for (PUPreProcessor preProcessor : preProcessors) {
                this.addPreProcessor(preProcessor);
            }
        }
    }

    public void addProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.offer(protocolFinder);
    }

    public void removeProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.remove(protocolFinder);
    }

    public void addProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.put(protocol, protocolHandler);
        }
    }

    public void removeProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.remove(protocol);
        }
    }

    public void addPreProcessor(PUPreProcessor preProcessor) {
        if (this.preProcessors == null) {
            this.preProcessors = new ArrayList<PUPreProcessor>(2);
        }
        this.preProcessors.add(preProcessor);
    }

    public void removePreProcessor(PUPreProcessor preProcessor) {
        if (this.preProcessors != null) {
            this.preProcessors.remove(preProcessor);
        }
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    private String findProtocol(Context context, PUProtocolRequest protocolRequest) throws IOException {
        Iterator<ProtocolFinder> iterator = this.protocolFinders.iterator();
        for (ProtocolFinder protocolFinder : this.protocolFinders) {
            String protocolName = protocolFinder.find(context, protocolRequest);
            if (protocolName == null) continue;
            return protocolName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapSelectionKey(SelectionKey selectionKey, ProtocolHandler protocolHandler) {
        if (this.mappedProtocols == null) {
            PUReadFilter pUReadFilter = this;
            synchronized (pUReadFilter) {
                if (this.mappedProtocols == null) {
                    this.mappedProtocols = PUReadFilter.createMappedProtocolsMap();
                }
            }
        }
        this.mappedProtocols.put(selectionKey, protocolHandler);
    }

    private static Map<SelectionKey, ProtocolHandler> createMappedProtocolsMap() {
        return Collections.synchronizedMap(new WeakHashMap());
    }
}

