/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.annotation.factory.AnnotatedElementHandlerFactory;
import com.sun.enterprise.deployment.annotation.factory.SJSASFactory;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebServicesDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ErrorHandler;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.DefaultErrorHandler;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.OptionalPkgDependency;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Archivist<T extends RootDeploymentDescriptor> {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");
    public static final String MANIFEST_VERSION_VALUE = "1.0";
    protected String path;
    protected boolean handleRuntimeInfo = true;
    protected boolean annotationProcessingRequested = false;
    protected Manifest manifest;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);
    protected ClassLoader classLoader = null;
    private boolean isValidatingXML = true;
    private boolean isValidatingRuntimeXML = false;
    private String validationLevel = "parsing";
    private String runtimeValidationLevel = "parsing";
    private ErrorHandler annotationErrorHandler = new DefaultErrorHandler();
    private static final String WSDL = ".wsdl";
    private static final String XML = ".xml";
    private static final String XSD = ".xsd";
    protected static final String APPLICATION_EXTENSION = ".ear";
    protected static final String APPCLIENT_EXTENSION = ".jar";
    protected static final String WEB_EXTENSION = ".war";
    protected static final String EJB_EXTENSION = ".jar";
    protected static final String CONNECTOR_EXTENSION = ".rar";
    protected static final String UPLOAD_EXTENSION = ".tmp";
    private static final String PROCESS_ANNOTATION_FOR_OLD_DD = "process.annotation.for.old.dd";
    private static final boolean processAnnotationForOldDD = Boolean.getBoolean("process.annotation.for.old.dd");
    protected T descriptor;
    @Inject
    Habitat habitat;
    @Inject
    SJSASFactory annotationFactory;
    @Inject
    ArchiveFactory archiveFactory;

    protected void initializeContext(Archivist other) {
        this.handleRuntimeInfo = other.isHandlingRuntimeInfo();
        this.annotationProcessingRequested = other.isAnnotationProcessingRequested();
        this.isValidatingXML = other.isValidatingXML;
        this.validationLevel = other.validationLevel;
        this.classLoader = other.classLoader;
        this.annotationErrorHandler = other.annotationErrorHandler;
    }

    public void setDescriptor(T descriptor) {
        this.descriptor = descriptor;
    }

    public T getDescriptor() {
        return this.descriptor;
    }

    public T open(ReadableArchive archive) throws IOException, SAXParseException {
        this.setManifest(archive.getManifest());
        T descriptor = this.readDeploymentDescriptors(archive);
        if (descriptor != null) {
            this.postOpen(descriptor, archive);
        }
        return descriptor;
    }

    public T open(String path) throws IOException, SAXParseException {
        this.path = path;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        return this.open(file);
    }

    public T open(File file) throws IOException, SAXParseException {
        this.path = file.getAbsolutePath();
        ReadableArchive archive = this.archiveFactory.openArchive(file);
        T descriptor = this.open(archive);
        archive.close();
        this.validate(null);
        return descriptor;
    }

    protected void postStandardDDsRead(T descriptor, ReadableArchive archive) throws IOException {
    }

    protected void postAnnotationProcess(T descriptor, ReadableArchive archive) throws IOException {
    }

    protected void postRuntimeDDsRead(T descriptor, ReadableArchive archive) throws IOException {
    }

    protected void postOpen(T descriptor, ReadableArchive archive) throws IOException {
    }

    public T readDeploymentDescriptors(ReadableArchive archive) throws IOException, SAXParseException {
        T descriptor = this.readStandardDeploymentDescriptor(archive);
        ModuleDescriptor newModule = this.createModuleDescriptor(descriptor);
        newModule.setArchiveUri(archive.getURI().getSchemeSpecificPart());
        this.readWebServicesDescriptor(archive, descriptor);
        this.readPersistenceDeploymentDescriptors(archive, this.getDescriptor());
        this.postStandardDDsRead(descriptor, archive);
        this.readAnnotations(archive, descriptor);
        this.postAnnotationProcess(descriptor, archive);
        this.readRuntimeDeploymentDescriptor(archive, descriptor);
        this.postRuntimeDDsRead(descriptor, archive);
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readAnnotations(ReadableArchive archive, T descriptor) throws IOException {
        boolean isFull = false;
        isFull = processAnnotationForOldDD ? ((RootDeploymentDescriptor)descriptor).isFullAttribute() : ((RootDeploymentDescriptor)descriptor).isFullFlag();
        if (!isFull && this.annotationProcessingRequested && this.classLoader != null) {
            try {
                ProcessingResult result = this.processAnnotations(descriptor, (Archive)archive);
                if (result == null || !ResultType.FAILED.equals((Object)result.getOverallResult())) return;
                DOLUtils.getDefaultLogger().severe(localStrings.getLocalString("enterprise.deployment.archivist.annotationprocessingfailed", "Annotations processing failed for {0}", new Object[]{archive.getURI()}));
                return;
            }
            catch (NoClassDefFoundError err) {
                if (!DOLUtils.getDefaultLogger().isLoggable(Level.WARNING)) return;
                DOLUtils.getDefaultLogger().warning("Error in annotation processing: " + err);
                return;
            }
            catch (AnnotationProcessorException ex) {
                DOLUtils.getDefaultLogger().severe(ex.getMessage());
                DOLUtils.getDefaultLogger().log(Level.FINE, ex.getMessage(), ex);
                throw new IllegalStateException(ex);
            }
        } else {
            if (!DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) return;
            DOLUtils.getDefaultLogger().fine("Annotation is not processed for this archive.");
        }
    }

    public void readPersistenceDeploymentDescriptors(ReadableArchive archive, T descriptor) throws IOException, SAXParseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult processAnnotations(T bundleDesc, Archive archive) throws AnnotationProcessorException, IOException {
        AnnotatedElementHandler aeHandler = AnnotatedElementHandlerFactory.createAnnotatedElementHandler(bundleDesc);
        if (aeHandler == null) {
            return null;
        }
        Scanner scanner = null;
        try {
            scanner = (Scanner)this.habitat.getComponent(Scanner.class, this.getModuleType().toString());
            if (scanner == null) {
                logger.log(Level.SEVERE, "Cannot find scanner for " + this.getManifest());
            }
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot find scanner for " + this.getModuleType(), e);
        }
        scanner.process(new File(archive.getURI()), bundleDesc, this.classLoader);
        if (!scanner.getElements().isEmpty()) {
            if (((RootDeploymentDescriptor)bundleDesc).isDDWithNoAnnotationAllowed()) {
                String ddName = this.getStandardDDFile().getDeploymentDescriptorPath();
                String explodedArchiveName = new File(archive.getURI()).getName();
                String archiveName = FileUtils.revertFriendlyFilenameExtension((String)explodedArchiveName);
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.oldDDwithAnnotation", "{0} in archive {1} is of version {2}, which cannot support annotations in an application.  Please upgrade the deployment descriptor to be a version supported by Java EE 5.0 (or later).", new Object[]{ddName, archiveName, ((RootDeploymentDescriptor)bundleDesc).getSpecVersion()}));
            }
            AnnotationProcessor ap = this.annotationFactory.getAnnotationProcessor();
            ProcessingContext ctx = ap.createContext();
            if (this.annotationErrorHandler != null) {
                ctx.setErrorHandler(this.annotationErrorHandler);
            }
            ctx.setProcessingInput(scanner);
            ctx.pushHandler(aeHandler);
            ClassLoader originalBundleClassLoader = null;
            try {
                originalBundleClassLoader = ((RootDeploymentDescriptor)bundleDesc).getClassLoader();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (originalBundleClassLoader == null) {
                ((RootDeploymentDescriptor)bundleDesc).setClassLoader(this.classLoader);
            }
            try {
                ProcessingResult processingResult = ap.process(ctx);
                return processingResult;
            }
            finally {
                if (originalBundleClassLoader == null) {
                    ((RootDeploymentDescriptor)bundleDesc).setClassLoader(null);
                }
            }
        }
        ((RootDeploymentDescriptor)bundleDesc).setFullFlag(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readStandardDeploymentDescriptor(ReadableArchive archive) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = archive.getEntry(this.getStandardDDFile().getDeploymentDescriptorPath());
            if (is != null) {
                RootDeploymentDescriptor result;
                DeploymentDescriptorFile<T> ddFile = this.getStandardDDFile();
                ddFile.setXMLValidation(this.getXMLValidation());
                ddFile.setXMLValidationLevel(this.validationLevel);
                if (archive.getURI() != null) {
                    ddFile.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                }
                RootDeploymentDescriptor rootDeploymentDescriptor = result = (RootDeploymentDescriptor)ddFile.read(is);
                return (T)rootDeploymentDescriptor;
            }
            T t = this.getDefaultBundleDescriptor();
            return t;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, T descriptor) throws IOException, SAXParseException {
        String ddFileEntryName = this.getRuntimeDeploymentDescriptorPath();
        if (!this.isHandlingRuntimeInfo() || ddFileEntryName == null) {
            return;
        }
        InputStream is = null;
        try {
            is = archive.getEntry(ddFileEntryName);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (archive.getURI() != null) {
                confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
            }
            if (is != null && confDD != null) {
                confDD.setXMLValidation(this.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(this.runtimeValidationLevel);
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void readRuntimeDDFromDeploymentPlan(ReadableArchive planArchive, T descriptor) throws IOException, SAXParseException {
        String runtimeDDPath = this.getRuntimeDeploymentDescriptorPath();
        if (runtimeDDPath == null || planArchive == null) {
            return;
        }
        Vector dpEntries = new Vector();
        Enumeration e = planArchive.entries();
        while (e.hasMoreElements()) {
            dpEntries.add(e.nextElement());
        }
        String entry = runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
        if (dpEntries.contains(entry)) {
            this.readRuntimeDDFromDeploymentPlan(entry, planArchive, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRuntimeDDFromDeploymentPlan(String entry, ReadableArchive planArchive, T descriptor) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = planArchive.getEntry(entry);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (is != null && confDD != null) {
                if (planArchive.getURI() != null) {
                    confDD.setErrorReportingString(planArchive.getURI().getSchemeSpecificPart());
                }
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readWebServicesDescriptor(ReadableArchive archive, T descriptor) throws IOException, SAXParseException {
        DeploymentDescriptorFile confDD = this.getWebServicesDDFile((Descriptor)descriptor);
        if (archive.getURI() != null) {
            confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
        }
        InputStream is = null;
        try {
            is = archive.getEntry(confDD.getDeploymentDescriptorPath());
            if (is != null) {
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.setXMLValidationLevel(this.validationLevel);
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void write() throws IOException {
        this.write(this.path);
    }

    public void write(String outPath) throws IOException {
        ReadableArchive in = this.archiveFactory.openArchive(new File(this.path));
        this.write(in, outPath);
        in.close();
    }

    public void write(ReadableArchive in, String outPath) throws IOException {
        ReadableArchive oldArchive = null;
        try {
            oldArchive = this.archiveFactory.openArchive(new File(outPath));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        WritableArchive out = null;
        Object bos = null;
        try {
            File outputFile = null;
            if (oldArchive != null && oldArchive.exists() && !(oldArchive instanceof WritableArchive)) {
                outputFile = Archivist.getTempFile(outPath);
                outputFile.delete();
                out = this.archiveFactory.createArchive(outputFile);
                oldArchive.close();
            } else {
                out = this.archiveFactory.createArchive(new File(outPath));
            }
            this.writeContents(in, out);
            out.close();
            in.close();
            if (outputFile != null) {
                ReadableArchive finalArchive = this.archiveFactory.openArchive(new File(outPath));
                finalArchive.delete();
                ReadableArchive tmpArchive = this.archiveFactory.openArchive(outputFile);
                tmpArchive.renameTo(outPath);
            }
        }
        catch (IOException ioe) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException outIoe) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public void write(ReadableArchive in, WritableArchive out) throws IOException {
        this.writeContents(in, out);
    }

    protected void writeContents(WritableArchive out) throws IOException {
        ReadableArchive in = this.archiveFactory.openArchive(new File(this.path));
        this.writeContents(in, out);
        in.close();
    }

    protected void writeContents(ReadableArchive in, WritableArchive out) throws IOException {
        this.writeContents(in, out, null);
    }

    protected void writeContents(ReadableArchive in, WritableArchive out, Vector entriesToSkip) throws IOException {
        if (in != null && in.exists()) {
            if (entriesToSkip == null) {
                entriesToSkip = this.getListOfFilesToSkip();
            } else {
                entriesToSkip.addAll(this.getListOfFilesToSkip());
            }
            this.copyJarElements(in, out, entriesToSkip);
        }
        this.writeDeploymentDescriptors(out);
        if (this.manifest != null) {
            OutputStream os = out.putNextEntry("META-INF/MANIFEST.MF");
            this.manifest.write(new DataOutputStream(os));
            out.closeEntry();
        }
    }

    public void writeDeploymentDescriptors(WritableArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(out);
        this.writeExtraDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(WritableArchive out) throws IOException {
        OutputStream os = out.putNextEntry(this.getDeploymentDescriptorPath());
        this.writeStandardDeploymentDescriptors(os);
        out.closeEntry();
        T desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor) {
            this.writeWebServicesDescriptors((BundleDescriptor)desc, out);
        }
    }

    public void writeRuntimeDeploymentDescriptors(WritableArchive out) throws IOException {
        DeploymentDescriptorFile confDD;
        T desc = this.getDescriptor();
        if (this.isHandlingRuntimeInfo() && (confDD = this.getConfigurationDDFile()) != null) {
            OutputStream os = out.putNextEntry(this.getRuntimeDeploymentDescriptorPath());
            confDD.write(desc, os);
            out.closeEntry();
        }
    }

    protected void writeExtraDeploymentDescriptors(WritableArchive out) throws IOException {
        this.writeRuntimeDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(OutputStream os) throws IOException {
        this.getStandardDDFile().write(this.getDescriptor(), os);
    }

    public void writeRuntimeDeploymentDescriptors(OutputStream os) throws IOException {
        DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
        if (confDD != null) {
            confDD.write(this.getDescriptor(), os);
        }
    }

    protected void writeWebServicesDescriptors(BundleDescriptor desc, WritableArchive out) throws IOException {
        if (desc.hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc);
            OutputStream os = out.putNextEntry(webServicesDD.getDeploymentDescriptorPath());
            webServicesDD.write(desc, os);
            out.closeEntry();
        }
    }

    public String getDeploymentDescriptorPath() {
        return this.getStandardDDFile().getDeploymentDescriptorPath();
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return null;
    }

    public String getRuntimeDeploymentDescriptorPath() {
        DeploymentDescriptorFile ddFile = this.getConfigurationDDFile();
        if (ddFile != null) {
            return ddFile.getDeploymentDescriptorPath();
        }
        return null;
    }

    public boolean containsRuntimeDeploymentDescriptors(Archive in) {
        String ddFileName = this.getRuntimeDeploymentDescriptorPath();
        if (ddFileName == null) {
            return false;
        }
        Enumeration e = in.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (!entryName.equals(ddFileName)) continue;
            return true;
        }
        return false;
    }

    public void setModuleDescriptor(ModuleDescriptor<T> module) {
        this.setDescriptor(module.getDescriptor());
        this.setManifest(module.getManifest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOptionalPkgDependenciesCheck(ReadableArchive archive) throws IOException {
        Vector libs;
        boolean dependenciesSatisfied = true;
        Manifest m = archive.getManifest();
        if (m != null) {
            dependenciesSatisfied = OptionalPkgDependency.optionalPkgDependencyLogic((Manifest)m, (String)archive.getURI().getSchemeSpecificPart());
        }
        if ((libs = this.getLibraries((Archive)archive)) != null) {
            for (String libUri : libs) {
                ZipInputStream jis = null;
                try {
                    jis = new JarInputStream(archive.getEntry(libUri));
                    m = ((JarInputStream)jis).getManifest();
                    if (m == null || OptionalPkgDependency.optionalPkgDependencyLogic((Manifest)m, (String)libUri)) continue;
                    dependenciesSatisfied = false;
                }
                finally {
                    if (jis != null) {
                        jis.close();
                    }
                }
            }
        }
        return dependenciesSatisfied;
    }

    public abstract ModuleType getModuleType();

    public abstract DeploymentDescriptorFile<T> getStandardDDFile();

    public abstract DeploymentDescriptorFile getConfigurationDDFile();

    public abstract T getDefaultBundleDescriptor();

    public void setDefaultBundleDescriptor(T defaultBD) {
    }

    public DeploymentDescriptorFile getWebServicesDDFile(Descriptor desc) {
        return new WebServicesDeploymentDescriptorFile(desc);
    }

    protected abstract String getArchiveExtension();

    protected abstract boolean postHandles(ReadableArchive var1) throws IOException;

    public boolean hasStandardDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream stIs = archive.getEntry(this.getDeploymentDescriptorPath());
        if (stIs != null) {
            stIs.close();
            return true;
        }
        return false;
    }

    public boolean hasRuntimeDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream runIs;
        if (this.getConfigurationDDFile() != null && (runIs = archive.getEntry(this.getConfigurationDDFile().getDeploymentDescriptorPath())) != null) {
            runIs.close();
            return true;
        }
        return false;
    }

    public boolean handles(ReadableArchive archive) {
        try {
            if (this.hasStandardDeploymentDescriptor(archive) || this.hasRuntimeDeploymentDescriptor(archive)) {
                return true;
            }
            String uri = archive.getURI().toString();
            File file = new File(archive.getURI());
            if (!file.isDirectory() && !uri.endsWith(".jar") && uri.endsWith(this.getArchiveExtension())) {
                return true;
            }
            if (this.postHandles(archive)) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public ModuleDescriptor createModuleDescriptor(T descriptor) {
        ModuleDescriptor<T> newModule = new ModuleDescriptor<T>();
        newModule.setModuleType(this.getModuleType());
        newModule.setDescriptor(descriptor);
        this.setDescriptor(descriptor);
        return newModule;
    }

    public void printDescriptor() {
        ((Descriptor)this.getDescriptor()).visit(new TracerVisitor());
    }

    public void setHandleRuntimeInfo(boolean handleRuntimeInfo) {
        this.handleRuntimeInfo = handleRuntimeInfo;
    }

    public boolean isHandlingRuntimeInfo() {
        return this.handleRuntimeInfo;
    }

    public void setAnnotationProcessingRequested(boolean annotationProcessingRequested) {
        this.annotationProcessingRequested = annotationProcessingRequested;
    }

    public boolean isAnnotationProcessingRequested() {
        return this.annotationProcessingRequested;
    }

    public void setAnnotationErrorHandler(ErrorHandler annotationErrorHandler) {
        this.annotationErrorHandler = annotationErrorHandler;
    }

    public ErrorHandler getAnnotationErrorHandler() {
        return this.annotationErrorHandler;
    }

    public void setManifest(Manifest m) {
        this.manifest = m;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setClassPath(String newClassPath) {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes atts = this.manifest.getMainAttributes();
        atts.putValue(Attributes.Name.CLASS_PATH.toString(), newClassPath);
    }

    public String getClassPath() {
        if (this.manifest == null) {
            return null;
        }
        Attributes atts = this.manifest.getMainAttributes();
        return atts.getValue(Attributes.Name.CLASS_PATH);
    }

    public Vector getLibraries(Archive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (entryName.indexOf(47) != -1 || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    protected String getUniqueEntryFilenameFor(Archive archive, String trialName) throws IOException {
        Vector<String> entriesNames = new Vector<String>();
        Enumeration e = archive.entries();
        while (e != null && e.hasMoreElements()) {
            entriesNames.add((String)e.nextElement());
        }
        return Descriptor.createUniqueFilenameAmongst(trialName, entriesNames);
    }

    public void saveRuntimeInfo(File output) throws IOException {
        File outputFile = output;
        if (outputFile == null) {
            outputFile = Archivist.getTempFile(this.path);
        }
        WritableArchive out = this.archiveFactory.createArchive(outputFile);
        ReadableArchive in = this.archiveFactory.openArchive(new File(this.path));
        Vector<String> skipFiles = new Vector<String>();
        skipFiles.add(this.getRuntimeDeploymentDescriptorPath());
        this.copyInto(in, out, skipFiles);
        in.close();
        OutputStream os = out.putNextEntry(this.getRuntimeDeploymentDescriptorPath());
        this.writeRuntimeDeploymentDescriptors(os);
        out.closeEntry();
        out.close();
        if (output == null) {
            ReadableArchive finalArchive = this.archiveFactory.openArchive(new File(this.path));
            finalArchive.delete();
            ReadableArchive tmpArchive = this.archiveFactory.openArchive(outputFile);
            tmpArchive.renameTo(this.path);
        }
    }

    public void applyRuntimeInfo(File runtimeDD, File output) throws IOException, SAXParseException {
        this.getConfigurationDDFile().read(this.getDescriptor(), new FileInputStream(runtimeDD));
        this.saveRuntimeInfo(output);
    }

    protected static File getTempFile(String fileOrDirPath) throws IOException {
        if (fileOrDirPath != null) {
            return Archivist.getTempFile(new File(fileOrDirPath));
        }
        return Archivist.getTempFile((File)null);
    }

    public Vector getListOfFilesToSkip() {
        Vector<String> filesToSkip = new Vector<String>();
        filesToSkip.add(this.getDeploymentDescriptorPath());
        if (this.manifest != null) {
            filesToSkip.add("META-INF/MANIFEST.MF");
        }
        if (this.getRuntimeDeploymentDescriptorPath() != null) {
            filesToSkip.add(this.getRuntimeDeploymentDescriptorPath());
        }
        filesToSkip.addAll(WebServicesDeploymentDescriptorFile.getAllDescriptorPaths());
        return filesToSkip;
    }

    protected static File getTempFile(File fileOrDir) throws IOException {
        File dir = null;
        if (fileOrDir == null) {
            dir = new File(System.getProperty("user.dir"));
        } else if (!fileOrDir.isDirectory()) {
            dir = fileOrDir.getParentFile();
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
        } else {
            dir = fileOrDir;
        }
        return File.createTempFile("tmp", ".jar", dir);
    }

    protected static void addFileToArchive(WritableArchive archive, String filePath, String entryName) throws IOException {
        FileInputStream is = new FileInputStream(new File(filePath));
        OutputStream os = archive.putNextEntry(entryName);
        ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
        is.close();
        archive.closeEntry();
    }

    protected void copyJarElements(ReadableArchive in, WritableArchive out, Vector ignoreList) throws IOException {
        Enumeration entries = in.entries();
        Enumeration outEntriesItr = out.entries();
        while (outEntriesItr.hasMoreElements()) {
            if (ignoreList == null) {
                ignoreList = new Vector();
            }
            ignoreList.add(outEntriesItr.nextElement());
        }
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (ignoreList != null && ignoreList.contains(anEntry)) continue;
                InputStream is = in.getEntry(anEntry);
                OutputStream os = out.putNextEntry(anEntry);
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                is.close();
                out.closeEntry();
            }
        }
    }

    protected boolean renameTmp(String from, String to) throws IOException {
        ReadableArchive finalArchive = this.archiveFactory.openArchive(new File(to));
        finalArchive.delete();
        ReadableArchive tmpArchive = this.archiveFactory.openArchive(new File(from));
        boolean success = tmpArchive.renameTo(to);
        if (!success) {
            throw new IOException("Error renaming JAR");
        }
        return success;
    }

    public void setArchiveUri(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setXMLValidation(boolean validate) {
        this.isValidatingXML = validate;
    }

    public boolean getXMLValidation() {
        return this.isValidatingXML;
    }

    public void setRuntimeXMLValidation(boolean validate) {
        this.isValidatingRuntimeXML = validate;
    }

    public boolean getRuntimeXMLValidation() {
        return this.isValidatingRuntimeXML;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    public void setRuntimeXMLValidationLevel(String level) {
        this.runtimeValidationLevel = level;
    }

    public String getRuntimeXMLValidationLevel() {
        return this.runtimeValidationLevel;
    }

    public void validate(ClassLoader aClassLoader) {
    }

    public void copyInto(WritableArchive target) throws IOException {
        ReadableArchive source = this.archiveFactory.openArchive(new File(this.path));
        this.copyInto(source, target);
    }

    public void copyInto(ReadableArchive source, WritableArchive target) throws IOException {
        this.copyInto(source, target, null, true);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, boolean overwriteManifest) throws IOException {
        this.copyInto(source, target, null, overwriteManifest);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, Vector entriesToSkip) throws IOException {
        this.copyInto(source, target, entriesToSkip, true);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, Vector entriesToSkip, boolean overwriteManifest) throws IOException {
        Manifest m;
        this.copyJarElements(source, target, entriesToSkip);
        if (overwriteManifest && (m = source.getManifest()) != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    public void extractEntry(String entryName, File out) throws IOException {
        ReadableArchive archive = this.archiveFactory.openArchive(new File(this.path));
        InputStream is = archive.getEntry(entryName);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
        ArchivistUtils.copy((InputStream)new BufferedInputStream(is), (OutputStream)os);
        archive.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAnEntry(ReadableArchive in, WritableArchive out, String entryName) throws IOException {
        InputStream is = null;
        InputStream is2 = null;
        ReadableArchive in2 = this.archiveFactory.openArchive(out.getURI());
        try {
            is = in.getEntry(entryName);
            is2 = in2.getEntry(entryName);
            if (is != null && is2 == null) {
                OutputStream os = out.putNextEntry(entryName);
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
            }
        }
        finally {
            in2.close();
            if (is != null) {
                is.close();
            }
            if (is2 != null) {
                is2.close();
            }
            out.closeEntry();
        }
    }

    public void copyStandardDeploymentDescriptors(ReadableArchive in, WritableArchive out) throws IOException {
        BundleDescriptor desc2;
        String entryName = this.getDeploymentDescriptorPath();
        this.copyAnEntry(in, out, entryName);
        T desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor && (desc2 = (BundleDescriptor)desc).hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc2);
            String anEntry = webServicesDD.getDeploymentDescriptorPath();
            this.copyAnEntry(in, out, anEntry);
        }
    }

    public void copyExtraElements(ReadableArchive in, WritableArchive out) throws IOException {
        Enumeration entries = in.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (anEntry.endsWith("META-INF/persistence.xml") || anEntry.indexOf(WSDL) == -1 && anEntry.indexOf(XML) == -1 && anEntry.indexOf(XSD) == -1) continue;
                this.copyAnEntry(in, out, anEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPersistenceDeploymentDescriptor(ReadableArchive subArchive, String puRoot, T descriptor) throws IOException, SAXParseException {
        String subArchiveURI = subArchive.getURI().getSchemeSpecificPart();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PURoot = [{0}] subArchive = {1}", new Object[]{puRoot, subArchiveURI});
        }
        if (((RootDeploymentDescriptor)descriptor).getPersistenceUnitsDescriptor(puRoot) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PU has been already read for = {0}", subArchiveURI);
            }
            return;
        }
        PersistenceDeploymentDescriptorFile persistenceDeploymentDescriptorFile = new PersistenceDeploymentDescriptorFile();
        persistenceDeploymentDescriptorFile.setErrorReportingString(subArchiveURI.toString());
        persistenceDeploymentDescriptorFile.setXMLValidation(this.getXMLValidation());
        persistenceDeploymentDescriptorFile.setXMLValidationLevel(this.getXMLValidationLevel());
        InputStream is = subArchive.getEntry(persistenceDeploymentDescriptorFile.getDeploymentDescriptorPath());
        if (is == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "{0} does not contain {1}, so it is not a PU Root.", new Object[]{subArchiveURI, persistenceDeploymentDescriptorFile.getDeploymentDescriptorPath()});
            }
            return;
        }
        try {
            PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)PersistenceUnitsDescriptor.class.cast(persistenceDeploymentDescriptorFile.read(descriptor, is));
            ((RootDeploymentDescriptor)descriptor).addPersistenceUnitsDescriptor(puRoot, persistenceUnitsDescriptor);
        }
        finally {
            is.close();
        }
    }

    public Object readMetaInfo(ReadableArchive archive) {
        return null;
    }
}

