/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.PrivateArchivist;
import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ArchivistFactory
implements ContractProvider {
    @Inject
    PrivateArchivist[] privateArchivists;
    @Inject
    ArchiveFactory archiveFactory;

    public Archivist getArchivist(ReadableArchive archive, ClassLoader cl) throws IOException {
        Archivist archivist = this.getPrivateArchivistFor(archive);
        if (archivist != null) {
            archivist.setClassLoader(cl);
        }
        return archivist;
    }

    public Archivist getArchivist(ModuleType moduleType) throws IOException {
        return this.getPrivateArchivistFor(moduleType);
    }

    Archivist getPrivateArchivistFor(ModuleType moduleType) throws IOException {
        for (PrivateArchivist pa : this.privateArchivists) {
            Archivist a = (Archivist)Archivist.class.cast(pa);
            if (!a.getModuleType().equals(moduleType)) continue;
            return a;
        }
        return null;
    }

    Archivist getPrivateArchivistFor(ReadableArchive archive) throws IOException {
        Archivist a;
        for (PrivateArchivist pa : this.privateArchivists) {
            Archivist a2 = (Archivist)Archivist.class.cast(pa);
            if (!a2.hasStandardDeploymentDescriptor(archive) && !a2.hasRuntimeDeploymentDescriptor(archive)) continue;
            return a2;
        }
        String uri = archive.getURI().getPath();
        File file = new File(uri);
        if (!file.isDirectory() && !uri.endsWith(".jar")) {
            for (PrivateArchivist pa : this.privateArchivists) {
                a = (Archivist)Archivist.class.cast(pa);
                if (!uri.endsWith(a.getArchiveExtension())) continue;
                return a;
            }
        }
        for (PrivateArchivist pa : this.privateArchivists) {
            a = (Archivist)Archivist.class.cast(pa);
            if (!a.postHandles(archive)) continue;
            return a;
        }
        return null;
    }
}

