/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SelectorFactory;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class SelectorThreadConfig {
    private static final String SELECTOR_TIMEOUT = "com.sun.grizzly.selector.timeout";
    private static final String MIN_THREAD = "com.sun.grizzly.minWorkerThreads";
    private static final String MAX_THREAD = "com.sun.grizzly.maxThreads";
    private static final String DISPLAY_CONFIGURATION = "com.sun.grizzly.displayConfiguration";
    private static final String MAX_KEEP_ALIVE_REQUEST = "com.sun.grizzly.maxKeepAliveRequests";
    private static final String DIRECT_BYTE_BUFFER_READ = "com.sun.grizzly.useDirectByteBuffer";
    private static final String PIPELINE_CLASS = "com.sun.grizzly.pipelineClass";
    private static final String MAX_SELECTOR_READ_THREAD = "com.sun.grizzly.maxSelectorReadThread";
    private static final String HTTP_HEADER_BUFFER_SIZE = "com.sun.grizzly.maxHttpHeaderSize";
    private static final String BYTE_BUFFER_VIEW = "com.sun.grizzly.useByteBufferView";
    private static final String ALGORITHM_CLASS_NAME = "com.sun.grizzly.algorithmClassName";
    private static final String MAX_SELECTOR = "com.sun.grizzly.maxSelectors";
    private static final String FACTORY_TIMEOUT = "com.sun.grizzly.factoryTimeout";
    private static final String ASYNCH_HANDLER_CLASS = "com.sun.grizzly.asyncHandlerClass";
    private static final String ASYNCH_HANDLER_PORT = "com.sun.grizzly.asyncHandler.ports";
    private static final String SNOOP_LOGGING = "com.sun.grizzly.enableSnoop";
    private static final String TEMPORARY_SELECTOR_TIMEOUT = "com.sun.grizzly.readTimeout";
    private static final String WRITE_TIMEOUT = "com.sun.grizzly.writeTimeout";
    private static final String BUFFER_RESPONSE = "com.sun.grizzly.http.bufferResponse";
    private static final String OOBInline = "com.sun.enterprise.web.connector.grizzly.OOBInline";
    private static final String MAX_BUFFERED_BYTES = "com.sun.grizzly.maxBufferedBytes";

    protected static void configureProperties(SelectorThread selectorThread) {
        if (System.getProperty(SELECTOR_TIMEOUT) != null) {
            try {
                SelectorThread.selectorTimeout = Integer.parseInt(System.getProperty(SELECTOR_TIMEOUT));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidSelectorTimeout");
            }
        }
        if (System.getProperty(TEMPORARY_SELECTOR_TIMEOUT) != null) {
            try {
                int timeout = Integer.parseInt(System.getProperty(TEMPORARY_SELECTOR_TIMEOUT));
                ByteBufferInputStream.setDefaultReadTimeout((int)timeout);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidReadTimeout");
            }
        }
        if (System.getProperty(WRITE_TIMEOUT) != null) {
            try {
                int timeout = Integer.parseInt(System.getProperty(WRITE_TIMEOUT));
                OutputWriter.setDefaultWriteTimeout((int)timeout);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidWriteTimeout");
            }
        }
        if (System.getProperty(MIN_THREAD) != null) {
            try {
                selectorThread.minWorkerThreads = Integer.parseInt(System.getProperty(MIN_THREAD));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidMinThreads");
            }
        }
        if (System.getProperty(MAX_THREAD) != null) {
            try {
                selectorThread.maxProcessorWorkerThreads = Integer.parseInt(System.getProperty(MAX_THREAD));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidMaxThreads");
            }
        }
        if (System.getProperty(DISPLAY_CONFIGURATION) != null) {
            selectorThread.displayConfiguration = Boolean.valueOf(System.getProperty(DISPLAY_CONFIGURATION));
        }
        if (System.getProperty(ASYNCH_HANDLER_PORT) != null) {
            String ports = System.getProperty(ASYNCH_HANDLER_PORT);
            StringTokenizer st = new StringTokenizer(ports, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(String.valueOf(selectorThread.getPort())) || System.getProperty(ASYNCH_HANDLER_CLASS) == null) continue;
                selectorThread.asyncHandler = (AsyncHandler)SelectorThreadConfig.loadClassAndInstanciate(System.getProperty(ASYNCH_HANDLER_CLASS));
                selectorThread.asyncExecution = true;
            }
        }
        if (System.getProperty(DIRECT_BYTE_BUFFER_READ) != null) {
            selectorThread.useDirectByteBuffer = Boolean.valueOf(System.getProperty(DIRECT_BYTE_BUFFER_READ));
        }
        if (System.getProperty(MAX_KEEP_ALIVE_REQUEST) != null) {
            try {
                selectorThread.maxKeepAliveRequests = Integer.parseInt(System.getProperty(MAX_KEEP_ALIVE_REQUEST));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(PIPELINE_CLASS) != null) {
            selectorThread.pipelineClassName = System.getProperty(PIPELINE_CLASS);
        }
        if (System.getProperty(ALGORITHM_CLASS_NAME) != null) {
            selectorThread.algorithmClassName = System.getProperty(ALGORITHM_CLASS_NAME);
        }
        if (System.getProperty(BYTE_BUFFER_VIEW) != null) {
            selectorThread.useByteBufferView = Boolean.valueOf(System.getProperty(BYTE_BUFFER_VIEW));
        }
        if (System.getProperty(MAX_SELECTOR_READ_THREAD) != null) {
            try {
                selectorThread.readThreadsCount = Integer.parseInt(System.getProperty(MAX_SELECTOR_READ_THREAD));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(MAX_SELECTOR) != null) {
            try {
                SelectorFactory.setMaxSelectors((int)Integer.parseInt(System.getProperty(MAX_SELECTOR)));
            }
            catch (NumberFormatException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(FACTORY_TIMEOUT) != null) {
            try {
                SelectorFactory.timeout = Integer.parseInt(System.getProperty(FACTORY_TIMEOUT));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(SNOOP_LOGGING) != null) {
            selectorThread.setEnableNioLogging(Boolean.valueOf(System.getProperty(SNOOP_LOGGING)));
        }
        if (System.getProperty(BUFFER_RESPONSE) != null) {
            selectorThread.setBufferResponse(Boolean.valueOf(System.getProperty(BUFFER_RESPONSE)));
        }
        if (System.getProperty(OOBInline) != null) {
            selectorThread.oOBInline = Boolean.valueOf(System.getProperty(OOBInline));
        }
        if (System.getProperty(MAX_BUFFERED_BYTES) != null) {
            try {
                SocketChannelOutputBuffer.setMaxBufferedBytes(Integer.parseInt(System.getProperty(MAX_BUFFERED_BYTES)));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidMaxBufferedBytes");
            }
        }
    }

    public static void configure(SelectorThread selectorThread) {
        SelectorThreadConfig.configureProperties(selectorThread);
    }

    private static Object loadClassAndInstanciate(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            SelectorThread.logger().log(Level.SEVERE, ex.getMessage() + ":" + className, ex);
            return null;
        }
    }
}

