/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenResolver {
    private final Map<String, String> props;

    public TokenResolver(Map<String, String> map) {
        this.props = map;
    }

    public void resolve(Map<String, String> map) {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            String value = map.get(key);
            if (!TokenResolver.hasToken(value)) continue;
            map.put(key, this.resolve(value));
        }
    }

    public void resolve(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (!TokenResolver.hasToken(s)) continue;
            list.set(i, this.resolve(s));
        }
    }

    private String resolve(String s) {
        if (TokenResolver.hasWindowsToken(s)) {
            s = this.windowsToUnixTokens(s);
        }
        List<Token> tokens = this.getTokens(s);
        String resolved = s;
        for (Token token : tokens) {
            resolved = GFLauncherUtils.replace(resolved, token.token, token.value);
        }
        return resolved;
    }

    private String windowsToUnixTokens(String s) {
        String replaced = s;
        while (replaced != null && replaced.indexOf(37) >= 0) {
            replaced = GFLauncherUtils.replace(replaced, "%", "${");
            replaced = GFLauncherUtils.replace(replaced, "%", "}");
        }
        if (replaced == null) {
            return s;
        }
        return replaced;
    }

    private static boolean hasWindowsToken(String s) {
        int index = s.indexOf(37);
        if (index < 0 || index >= s.length() - 1) {
            return false;
        }
        return s.indexOf(37, index + 1) >= 0;
    }

    private List<Token> getTokens(String s) {
        Token token;
        int index = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = this.getToken(s, index)) != null) {
            tokens.add(token);
            index = token.start + "${".length();
        }
        return tokens;
    }

    private Token getToken(String s, int index) {
        if (s == null || index >= s.length()) {
            return null;
        }
        Token token = new Token();
        token.start = s.indexOf("${", index);
        token.end = s.indexOf("}", token.start + 2);
        if (token.end <= 0 || token.start < 0) {
            return null;
        }
        token.token = s.substring(token.start, token.end + 1);
        token.name = s.substring(token.start + "${".length(), token.end);
        token.value = this.props.get(token.name);
        if (token.value == null) {
            token.value = token.token;
        }
        return token;
    }

    private static boolean hasToken(String s) {
        if (s == null) {
            return false;
        }
        if (GFLauncherUtils.isWindows() && TokenResolver.hasWindowsToken(s)) {
            return true;
        }
        return s.indexOf("${") >= 0;
    }

    private static class Token {
        int start;
        int end;
        String token;
        String name;
        String value;
        static final String TOKEN_START = "${";
        static final String TOKEN_END = "}";

        private Token() {
        }

        public String toString() {
            return "name: " + this.name + ", token: " + this.token + ", value: " + this.value;
        }
    }
}

