/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;

public final class DebugMonitor
extends TimerTask {
    private Hashtable _instances = null;
    private final EmbeddedWebContainer _embedded;
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private WebContainer webContainer = null;

    public DebugMonitor() {
        this._embedded = null;
    }

    public DebugMonitor(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
    }

    public String getApplicationId(Context ctx) {
        WebModule wm = (WebModule)ctx;
        return wm.getID();
    }

    public String getApplicationName(Context ctx) {
        return ctx.getName();
    }

    public void run() {
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        _logger.finest("webAppName = " + webAppName);
                        if (nextManager instanceof StandardManager) continue;
                        _logger.log(Level.SEVERE, "MONITORING::" + webAppName + ": " + ((PersistentManagerBase)nextManager).getMonitorAttributeValues());
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }
}

