/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.Result;
import com.sun.enterprise.v3.server.ServerEnvironment;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.web.JSPCompiler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    GrizzlyService grizzlyAdapter;
    private static final String ADMIN_VS = "__asadmin";
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    private static WebBundleDescriptor defaultWebXMLWbd = null;

    protected String getModuleType() {
        return "web";
    }

    public MetaData getMetaData() {
        String[] otherExportedPackages;
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("javax.javaee:javaee", "5.0");
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        for (String otherExportedPackage : otherExportedPackages = new String[]{"org.glassfish.web:webtier", "org.glassfish.web:jsf-connector", "org.glassfish.web:jstl-impl", "org.glassfish.external:grizzly-module"}) {
            module = this.modulesRegistry.makeModuleFor(otherExportedPackage, null);
            if (module == null) continue;
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), new Class[]{Application.class}, null);
    }

    protected WebBundleDescriptor getDefaultBundleDescriptor() {
        return this.getDefaultWebXMLBundleDescriptor();
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        Application app = super.parseModuleMetaData(dc);
        if (app.isVirtual()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            Properties params = dc.getCommandParameters();
            String contextRoot = params.getProperty("contextroot") != null ? params.getProperty("contextroot") : (wbd.getContextRoot() != null && wbd.getContextRoot().length() > 0 ? wbd.getContextRoot() : params.getProperty("name"));
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            wbd.setContextRoot(contextRoot);
            wbd.setName(params.getProperty("name"));
            dc.getProps().setProperty("context-root", contextRoot);
        }
        return app;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = null;
        try {
            ReadableArchive source = dc.getSource();
            String docBase = source.getURI().getSchemeSpecificPart();
            Properties params = dc.getCommandParameters();
            String virtualServers = params.getProperty("virtualservers");
            wmInfo = new WebModuleConfig();
            WebBundleDescriptor wbd = (WebBundleDescriptor)((Application)dc.getModuleMetaData(Application.class)).getStandaloneBundleDescriptor();
            wmInfo.setDescriptor(wbd);
            wmInfo.setVirtualServers(virtualServers);
            wmInfo.setLocation(dc.getSourceDir().getAbsolutePath());
            wmInfo.setObjectType(dc.getProps().getProperty("object-type"));
            wmInfo.setWorkDir(dc.getScratchDir("jsp").getAbsolutePath());
        }
        catch (Exception ex) {
            dc.getLogger().log(Level.WARNING, "loadWebModuleConfig", ex);
        }
        return wmInfo;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        boolean precompileJSP = Boolean.parseBoolean(params.getProperty("precompilejsp"));
        if (precompileJSP) {
            this.runJSPC(dc);
        }
    }

    public WebApplication load(WebContainer container, DeploymentContext dc) {
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        WebBundleDescriptor wbd = wmInfo.getDescriptor();
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        WebApplication application = new WebApplication(container, wbd, dc.getClassLoader());
        wmInfo.setAppClassLoader(dc.getClassLoader());
        boolean loadToAll = vsList == null || vsList.size() == 0;
        List<Result<WebModule>> results = container.loadWebModule(wmInfo, "null");
        dc.getLogger().info("Loading application " + dc.getCommandParameters().getProperty("name") + " at " + wbd.getContextRoot());
        for (Result<WebModule> result : results) {
            if (result.isSuccess()) {
                VirtualServer vs = (VirtualServer)((WebModule)result.result()).getParent();
                HashSet<String> c = new HashSet<String>();
                c.add(vs.getID());
                if (!loadToAll && !vsList.contains(vs.getName()) && !this.isAliasMatched(vsList, vs)) continue;
                for (int port : vs.getPorts()) {
                    Adapter adapter = container.adapterMap.get(port);
                    this.grizzlyAdapter.registerEndpoint(wbd.getContextRoot(), c, adapter, (ApplicationContainer)application);
                }
                continue;
            }
            dc.getLogger().log(Level.SEVERE, "Error while deploying", result.exception());
        }
        return application;
    }

    public void unload(WebApplication webApplication, DeploymentContext dc) {
        Properties params = dc.getCommandParameters();
        String ctxtRoot = webApplication.getDescriptor().getContextRoot();
        if (!ctxtRoot.equals("") && !ctxtRoot.startsWith("/")) {
            ctxtRoot = "/" + ctxtRoot;
        } else if ("/".equals(ctxtRoot)) {
            ctxtRoot = "";
        }
        List targets = StringUtils.parseStringList((String)params.getProperty("virtualservers"), (String)" ,");
        boolean unloadFromAll = targets == null || targets.size() == 0;
        Container[] hosts = webApplication.getContainer().engine.findChildren();
        for (int i = 0; i < hosts.length; ++i) {
            StandardContext ctxt;
            StandardHost vs = (StandardHost)hosts[i];
            if (unloadFromAll && ADMIN_VS.equals(vs.getName()) || !unloadFromAll && !targets.contains(vs.getName()) && !this.isAliasMatched(targets, vs) || (ctxt = (StandardContext)vs.findChild(ctxtRoot)) == null) continue;
            vs.removeChild(ctxt);
            try {
                ctxt.destroy();
            }
            catch (Exception ex) {
                dc.getLogger().log(Level.WARNING, "Unable to destroy web module " + ctxt, ex);
            }
            dc.getLogger().info("Undeployed web module " + ctxt + " from virtual server " + vs.getName());
            this.grizzlyAdapter.unregisterEndpoint(ctxtRoot, (ApplicationContainer)webApplication);
        }
    }

    private boolean isAliasMatched(List targets, StandardHost vs) {
        String[] aliasNames = vs.getAliases();
        for (int i = 0; i < aliasNames.length; ++i) {
            if (!targets.contains(aliasNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    public WebBundleDescriptor getDefaultWebXMLBundleDescriptor() {
        this.initDefaultWebXMLBundleDescriptor();
        WebBundleDescriptor defaultWebBundleDesc = new WebBundleDescriptor();
        if (defaultWebXMLWbd != null) {
            defaultWebBundleDesc.addWebBundleDescriptor(defaultWebXMLWbd);
        }
        return defaultWebBundleDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initDefaultWebXMLBundleDescriptor() {
        if (defaultWebXMLWbd != null) {
            return;
        }
        FileInputStream fis = null;
        try {
            String defaultWebXMLPath = this.env.getConfigDirPath() + File.separator + DEFAULT_WEB_XML;
            File file = new File(defaultWebXMLPath);
            if (file.exists()) {
                fis = new FileInputStream(file);
                WebDeploymentDescriptorFile wddf = new WebDeploymentDescriptorFile();
                wddf.setXMLValidation(false);
                defaultWebXMLWbd = (WebBundleDescriptor)wddf.read((InputStream)fis);
            }
        }
        catch (Exception e) {
            LogDomains.getLogger((String)"javax.enterprise.system.container.web").warning("Error in parsing default-web.xml");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptor wbd = (WebBundleDescriptor)((Application)dc.getModuleMetaData(Application.class)).getStandaloneBundleDescriptor();
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            StringBuffer classpath = new StringBuffer();
            classpath.append(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            classpath.append(ASClassLoaderUtil.getWebModuleClassPath(this.sc.getDefaultHabitat(), wbd.getApplication().getName()));
            JSPCompiler.compile(inDir, outDir, wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            dc.getLogger().log(Level.SEVERE, "Error compiling JSP", de);
            throw de;
        }
    }
}

