/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.integration.RealmAdapterProxy;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transaction;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;
import org.apache.jasper.servlet.JspServlet;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public final class J2EEInstanceListener
implements InstanceListener {
    protected static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected static ResourceBundle _rb = _logger.getResourceBundle();
    private static final HashSet beforeEvents = new HashSet(4);
    private static final HashSet afterEvents = new HashSet(4);
    @Inject(optional=true)
    private Realm realmAdapter;
    private InvocationManager im;
    private JavaEETransactionManager tm;
    private InjectionManager injectionMgr;
    private boolean initialized = false;
    private static AuthPermission doAsPrivilegedPerm;

    public void instanceEvent(InstanceEvent event) {
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        this.init(wm);
        String eventType = event.getType();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "*** InstanceEvent: " + eventType);
        }
        if (beforeEvents.contains(eventType)) {
            this.handleBeforeEvent(event, eventType);
        } else if (afterEvents.contains(eventType)) {
            this.handleAfterEvent(event, eventType);
        }
    }

    private synchronized void init(WebModule wm) {
        if (this.initialized) {
            return;
        }
        ServerContext serverContext = wm.getServerContext();
        if (serverContext == null) {
            String msg = _rb.getString("webmodule.noservercontext");
            msg = MessageFormat.format(msg, wm.getName());
            throw new IllegalStateException(msg);
        }
        this.im = (InvocationManager)serverContext.getDefaultHabitat().getByContract(InvocationManager.class);
        this.tm = (JavaEETransactionManager)serverContext.getDefaultHabitat().getByContract(JavaEETransactionManager.class);
        this.injectionMgr = (InjectionManager)serverContext.getDefaultHabitat().getByContract(InjectionManager.class);
        this.initialized = true;
    }

    private void handleBeforeEvent(InstanceEvent event, String eventType) {
        ServletRequest request;
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        Object instance = null;
        instance = eventType.equals("beforeFilter") ? event.getFilter() : event.getServlet();
        Realm ra = context.getRealm();
        if (ra != null && (request = event.getRequest()) != null && request instanceof HttpServletRequest) {
            Principal prin;
            HttpServletRequest hreq;
            HttpServletRequest base = hreq = (HttpServletRequest)request;
            Principal basePrincipal = prin = hreq.getUserPrincipal();
            boolean wrapped = false;
            while (prin != null && base != null) {
                ServletRequest sr;
                if (base instanceof ServletRequestWrapper && (sr = ((ServletRequestWrapper)base).getRequest()) instanceof HttpServletRequest) {
                    base = (HttpServletRequest)sr;
                    wrapped = true;
                    continue;
                }
                if (wrapped) {
                    basePrincipal = base.getUserPrincipal();
                    break;
                }
                if (base instanceof CoyoteRequestFacade) {
                    if (base.getClass() == CoyoteRequestFacade.class) break;
                    basePrincipal = ((CoyoteRequestFacade)base).getUnwrappedCoyoteRequest().getUserPrincipal();
                    break;
                }
                basePrincipal = base.getUserPrincipal();
                break;
            }
            if (prin != null && prin == basePrincipal) {
                if (this.realmAdapter != null && this.realmAdapter instanceof RealmAdapterProxy) {
                    ((RealmAdapterProxy)this.realmAdapter).setCurrentSecurityContextWithWebPrincipal(prin);
                }
            } else if (prin != basePrincipal) {
                J2EEInstanceListener.checkObjectForDoAsPermission(hreq);
                if (this.realmAdapter != null && this.realmAdapter instanceof RealmAdapterProxy) {
                    ((RealmAdapterProxy)this.realmAdapter).setCurrentSecurityContext(prin);
                }
            }
        }
        WebComponentInvocation inv = new WebComponentInvocation(wm, instance);
        try {
            WebBundleDescriptor desc;
            this.im.preInvoke((ComponentInvocation)inv);
            if (eventType.equals("beforeService")) {
                Transaction tran = null;
                tran = this.tm.getTransaction();
                if (tran != null) {
                    inv.setTransaction(tran);
                }
                this.tm.enlistComponentResources();
            } else if (eventType.equals("beforeInit") && (desc = wm.getWebBundleDescriptor()) != null && instance.getClass() != DefaultServlet.class && instance.getClass() != JspServlet.class) {
                this.injectionMgr.injectInstance(instance, (JndiNameEnvironment)desc);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(_logger.getResourceBundle().getString("web_server.excep_handle_before_event"), ex);
        }
    }

    private static void checkObjectForDoAsPermission(final Object o) throws AccessControlException {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ProtectionDomain pD = o.getClass().getProtectionDomain();
                    Policy p = Policy.getPolicy();
                    if (!p.implies(pD, doAsPrivilegedPerm)) {
                        throw new AccessControlException("permission required to override getUserPrincipal", doAsPrivilegedPerm);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent event, String eventType) {
        block27: {
            WebComponentInvocation inv;
            Object instance;
            Context context;
            block24: {
                context = (Context)event.getWrapper().getParent();
                if (!(context instanceof WebModule)) {
                    return;
                }
                WebModule wm = (WebModule)context;
                instance = null;
                instance = eventType.equals("afterFilter") ? event.getFilter() : event.getServlet();
                inv = new WebComponentInvocation(wm, instance);
                try {
                    this.im.postInvoke((ComponentInvocation)inv);
                    Object var9_7 = null;
                    if (!eventType.equals("afterDestroy")) break block24;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (eventType.equals("afterDestroy")) {
                        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                        WebBundleDescriptor desc = wm.getWebBundleDescriptor();
                        if (desc != null && instance.getClass() != DefaultServlet.class && instance.getClass() != JspServlet.class) {
                            try {
                                this.injectionMgr.invokeInstancePreDestroy(instance, (JndiNameEnvironment)desc);
                            }
                            catch (InjectionException ie) {
                                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ie);
                            }
                        }
                    }
                    if (eventType.equals("afterFilter") || eventType.equals("afterService")) {
                        if (this.im.getCurrentInvocation() == null) {
                            try {
                                Realm ra = context.getRealm();
                                if (ra != null && ra instanceof RealmAdapterProxy) {
                                    ((RealmAdapterProxy)ra).logout();
                                }
                            }
                            catch (Exception ex) {
                                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                            }
                            try {
                                if (this.tm.getTransaction() != null) {
                                    this.tm.rollback();
                                }
                                this.tm.cleanTxnTimeout();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                    }
                    throw throwable;
                }
                this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                WebBundleDescriptor desc = wm.getWebBundleDescriptor();
                if (desc != null && instance.getClass() != DefaultServlet.class && instance.getClass() != JspServlet.class) {
                    try {
                        this.injectionMgr.invokeInstancePreDestroy(instance, (JndiNameEnvironment)desc);
                    }
                    catch (InjectionException ie) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ie);
                    }
                }
            }
            if (!eventType.equals("afterFilter") && !eventType.equals("afterService")) break block27;
            if (this.im.getCurrentInvocation() == null) {
                try {
                    Realm ra = context.getRealm();
                    if (ra != null && ra instanceof RealmAdapterProxy) {
                        ((RealmAdapterProxy)ra).logout();
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                }
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                    this.tm.cleanTxnTimeout();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
            {
                break block27;
                catch (Exception ex) {
                    throw new RuntimeException(_logger.getResourceBundle().getString("web_server.excep_handle_after_event"), ex);
                }
            }
        }
    }

    static {
        beforeEvents.add("beforeService");
        beforeEvents.add("beforeFilter");
        beforeEvents.add("beforeInit");
        beforeEvents.add("beforeDestroy");
        afterEvents.add("afterService");
        afterEvents.add("afterFilter");
        afterEvents.add("afterInit");
        afterEvents.add("afterDestroy");
        doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    }
}

