/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import com.sun.appserv.ProxyHandler;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.ProtocolHandler;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.CoyoteAdapter;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.coyote.tomcat5.CoyoteServerSocketFactory;
import org.apache.coyote.tomcat5.MapperListener;
import org.apache.tomcat.util.IntrospectionUtils;

public class CoyoteConnector
implements Connector,
Lifecycle,
MBeanRegistration {
    protected static Log log = LogFactory.getLog(CoyoteConnector.class);
    private String defaultClassName = "org.apache.coyote.tomcat5.CoyoteAdapter";
    private HashMap properties = new HashMap();
    private Service service = null;
    private int acceptCount = 10;
    private String address = null;
    private boolean allowTrace = true;
    private int bufferSize = 4096;
    protected Container container = null;
    private String compression = "off";
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private int maxHttpHeaderSize = 4096;
    private boolean xpoweredBy;
    private static final String info = "org.apache.coyote.tomcat5.CoyoteConnector/2.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionLinger = -1;
    private int connectionTimeout = 60000;
    private int connectionUploadTimeout = 300000;
    private int serverSocketTimeout = 0;
    private int port = 8080;
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String defaultHost;
    private String scheme = "http";
    private boolean secure = false;
    private boolean blocking = false;
    private boolean tomcatAuthentication = true;
    protected StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    private boolean disableUploadTimeout = true;
    private int maxKeepAliveRequests = 100;
    private int maxPostSize = 0x200000;
    protected boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private boolean tcpNoDelay = true;
    private String protocolHandlerClassName = "com.sun.enterprise.v3.web.connector.grizzly.CoyoteConnectorLauncher";
    private ProtocolHandler protocolHandler = null;
    private Adapter adapter = null;
    protected Mapper mapper = new Mapper();
    protected MapperListener mapperListener = new MapperListener(this.mapper);
    private String uriEncoding = "UTF-8";
    private boolean isEnabled = true;
    protected boolean authPassthroughEnabled = false;
    protected ProxyHandler proxyHandler = null;
    private String selectorThreadImpl = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    ObjectName controller;

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
        this.setProperty("service", service);
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
        this.setProperty("compression", compression);
    }

    public int getConnectionLinger() {
        return this.connectionLinger;
    }

    public void setConnectionLinger(int connectionLinger) {
        this.connectionLinger = connectionLinger;
        this.setProperty("soLinger", String.valueOf(connectionLinger));
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.setProperty("soTimeout", String.valueOf(connectionTimeout));
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int connectionUploadTimeout) {
        this.connectionUploadTimeout = connectionUploadTimeout;
        this.setProperty("timeout", String.valueOf(connectionUploadTimeout));
    }

    public int getServerSocketTimeout() {
        return this.serverSocketTimeout;
    }

    public void setServerSocketTimeout(int serverSocketTimeout) {
        this.serverSocketTimeout = serverSocketTimeout;
        this.setProperty("serverSoTimeout", String.valueOf(serverSocketTimeout));
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
        this.setProperty("backlog", String.valueOf(count));
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.setProperty("address", address);
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.setProperty("bufferSize", String.valueOf(bufferSize));
    }

    public Container getContainer() {
        if (this.container == null) {
            this.findContainer();
        }
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public ServerSocketFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public String getInfo() {
        return info;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
        this.setProperty("minThreads", String.valueOf(minProcessors));
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
        this.setProperty("maxThreads", String.valueOf(maxProcessors));
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
        this.setProperty("maxPostSize", String.valueOf(maxPostSize));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11Protocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.jk.server.JkCoyoteHandler".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return null;
    }

    public void setProtocol(String protocol) {
        if (protocol.equals("HTTP/1.1")) {
            this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11Protocol");
        } else if (protocol.equals("AJP/1.3")) {
            this.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else {
            this.setProtocolHandlerClassName(null);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        if (proxyName != null && proxyName.length() > 0) {
            this.proxyName = proxyName;
            this.setProperty("proxyName", proxyName);
        } else {
            this.proxyName = null;
            this.removeProperty("proxyName");
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
        this.setProperty("disableUploadTimeout", String.valueOf(isDisabled));
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int size) {
        this.maxHttpHeaderSize = size;
        this.setProperty("maxHttpHeaderSize", String.valueOf(size));
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setProperty("maxKeepAliveRequests", String.valueOf(mkar));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.setProperty("scheme", scheme);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", String.valueOf(secure));
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
        this.setProperty("blocking", String.valueOf(blocking));
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
        this.setProperty("tomcatAuthentication", String.valueOf(tomcatAuthentication));
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        this.setProperty("tcpNoDelay", String.valueOf(tcpNoDelay));
    }

    public String getURIEncoding() {
        return this.uriEncoding;
    }

    public void setURIEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
        this.setProperty("uRIEncoding", uriEncoding);
    }

    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public boolean getAuthPassthroughEnabled() {
        return this.authPassthroughEnabled;
    }

    public void setAuthPassthroughEnabled(boolean authPassthroughEnabled) {
        this.authPassthroughEnabled = authPassthroughEnabled;
    }

    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Request createRequest() {
        CoyoteRequest request = new CoyoteRequest();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        CoyoteResponse response = new CoyoteResponse();
        response.setConnector(this);
        return response;
    }

    private void log(String message) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(localName + " " + message);
        } else {
            System.out.println(localName + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(localName + " " + message, throwable);
        } else {
            System.out.println(localName + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize() throws LifecycleException {
        Constructor<?> constructor;
        Class<?> clazz;
        if (this.initialized) {
            log.info((Object)this.sm.getString("coyoteConnector.alreadyInitialized"));
            return;
        }
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardEngine) {
            try {
                StandardEngine cb = (StandardEngine)this.container;
                String encodedAddr = null;
                if (this.getAddress() != null) {
                    encodedAddr = URLEncoder.encode(this.getAddress());
                }
                String addSuffix = this.getAddress() == null ? "" : ",address=" + encodedAddr;
                this.oname = new ObjectName(cb.getName() + ":type=Connector,port=" + this.getPort() + addSuffix);
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
                this.controller = this.oname;
            }
            catch (Exception e) {
                log.error((Object)"Error registering connector ", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating name for connector " + this.oname));
            }
        }
        if (this.adapter == null) {
            try {
                clazz = Class.forName(this.defaultClassName);
                constructor = clazz.getConstructor(CoyoteConnector.class);
                this.adapter = (Adapter)constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new LifecycleException(this.sm.getString("coyoteConnector.adapterClassInstantiationFailed", e));
            }
        }
        if (this.protocolHandler == null) {
            try {
                clazz = Class.forName(this.protocolHandlerClassName);
                if (this.protocolHandlerClassName.equals("org.apache.jk.server.JkCoyoteHandler")) {
                    this.protocolHandler = (ProtocolHandler)clazz.newInstance();
                    if (!(this.adapter instanceof CoyoteAdapter)) throw new IllegalStateException(this.sm.getString("coyoteConnector.illegalAdapter", this.adapter));
                    ((CoyoteAdapter)this.adapter).setCompatWithTomcat(true);
                } else {
                    constructor = clazz.getConstructor(Boolean.TYPE, Boolean.TYPE, String.class);
                    this.protocolHandler = (ProtocolHandler)constructor.newInstance(this.secure, this.blocking, this.selectorThreadImpl);
                }
            }
            catch (Exception e) {
                throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInstantiationFailed", e));
            }
        }
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty(this.protocolHandler, "jkHome", System.getProperty("catalina.base"));
        if (this.factory instanceof CoyoteServerSocketFactory) {
            IntrospectionUtils.setProperty(this.protocolHandler, "secure", "true");
            CoyoteServerSocketFactory ssf = (CoyoteServerSocketFactory)this.factory;
            IntrospectionUtils.setProperty(this.protocolHandler, "algorithm", ssf.getAlgorithm());
            if (ssf.getClientAuth()) {
                IntrospectionUtils.setProperty(this.protocolHandler, "clientauth", "" + ssf.getClientAuth());
            }
            IntrospectionUtils.setProperty(this.protocolHandler, "keystore", ssf.getKeystoreFile());
            IntrospectionUtils.setProperty(this.protocolHandler, "randomfile", ssf.getRandomFile());
            IntrospectionUtils.setProperty(this.protocolHandler, "rootfile", ssf.getRootFile());
            IntrospectionUtils.setProperty(this.protocolHandler, "keypass", ssf.getKeystorePass());
            IntrospectionUtils.setProperty(this.protocolHandler, "keytype", ssf.getKeystoreType());
            IntrospectionUtils.setProperty(this.protocolHandler, "protocol", ssf.getProtocol());
            IntrospectionUtils.setProperty(this.protocolHandler, "protocols", ssf.getProtocols());
            IntrospectionUtils.setProperty(this.protocolHandler, "sSLImplementation", ssf.getSSLImplementation());
            IntrospectionUtils.setProperty(this.protocolHandler, "ciphers", ssf.getCiphers());
            IntrospectionUtils.setProperty(this.protocolHandler, "keyAlias", ssf.getKeyAlias());
        } else {
            IntrospectionUtils.setProperty(this.protocolHandler, "secure", "" + this.secure);
        }
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            String trnName = this.translateAttributeName(name);
            IntrospectionUtils.setProperty(this.protocolHandler, trnName, value);
        }
        try {
            this.protocolHandler.init();
            return;
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInitializationFailed", e));
        }
    }

    private String translateAttributeName(String name) {
        if ("clientAuth".equals(name)) {
            return "clientauth";
        }
        if ("keystoreFile".equals(name)) {
            return "keystore";
        }
        if ("randomFile".equals(name)) {
            return "randomfile";
        }
        if ("rootFile".equals(name)) {
            return "rootfile";
        }
        if ("keystorePass".equals(name)) {
            return "keypass";
        }
        if ("keystoreType".equals(name)) {
            return "keytype";
        }
        if ("sslProtocol".equals(name)) {
            return "protocol";
        }
        if ("sslProtocols".equals(name)) {
            return "protocols";
        }
        return name;
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.started) {
            log.info((Object)this.sm.getString("coyoteConnector.alreadyStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.oname != null) {
            try {
                Registry.getRegistry().registerComponent((Object)this.protocolHandler, this.domain, "protocolHandler", "type=protocolHandler,className=" + this.protocolHandlerClassName);
            }
            catch (Exception ex) {
                log.error((Object)this.sm.getString("coyoteConnector.protocolRegistrationFailed"), (Throwable)ex);
            }
        } else {
            log.info((Object)this.sm.getString("coyoteConnector.cannotRegisterProtocol"));
        }
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerStartFailed", e));
        }
        if (this.domain != null) {
            this.mapperListener.setDomain(this.domain);
            this.mapperListener.setPort(this.getPort());
            this.mapperListener.setDefaultHost(this.defaultHost);
            this.mapperListener.init();
            try {
                Registry.getRegistry().registerComponent((Object)this.mapper, this.domain, "Mapper", "type=Mapper");
            }
            catch (Exception ex) {
                log.error((Object)this.sm.getString("coyoteConnector.protocolRegistrationFailed"), (Throwable)ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            log.error((Object)this.sm.getString("coyoteConnector.notStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.domain != null) {
            try {
                Registry.getRegistry().unregisterComponent(new ObjectName(this.domain, "type", "Mapper"));
                Registry.getRegistry().unregisterComponent(new ObjectName(this.domain + ":type=protocolHandler,className=" + this.protocolHandlerClassName));
            }
            catch (MalformedObjectNameException e) {
                log.info((Object)"Error unregistering mapper ", (Throwable)e);
            }
        }
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerDestroyFailed", e));
        }
    }

    public boolean getClientAuth() {
        boolean ret = false;
        String prop = (String)this.getProperty("clientauth");
        if (prop != null) {
            ret = Boolean.valueOf(prop);
        } else {
            ServerSocketFactory factory = this.getFactory();
            if (factory instanceof CoyoteServerSocketFactory) {
                ret = ((CoyoteServerSocketFactory)factory).getClientAuth();
            }
        }
        return ret;
    }

    public void setClientAuth(boolean clientAuth) {
        this.setProperty("clientauth", String.valueOf(clientAuth));
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setClientAuth(clientAuth);
        }
    }

    public String getKeystoreFile() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("keystore");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getKeystoreFile();
        }
        return ret;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.setProperty("keystore", keystoreFile);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setKeystoreFile(keystoreFile);
        }
    }

    public String getKeystorePass() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("keypass");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            return ((CoyoteServerSocketFactory)factory).getKeystorePass();
        }
        return ret;
    }

    public void setKeystorePass(String keystorePass) {
        this.setProperty("keypass", keystorePass);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setKeystorePass(keystorePass);
        }
    }

    public String getCiphers() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("ciphers");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getCiphers();
        }
        return ret;
    }

    public void setCiphers(String ciphers) {
        this.setProperty("ciphers", ciphers);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setCiphers(ciphers);
        }
    }

    public void setSSLSessionTimeout(String timeout) {
        this.setProperty("sslSessionTimeout", timeout);
    }

    public void setSSL3SessionTimeout(String timeout) {
        this.setProperty("ssl3SessionTimeout", timeout);
    }

    public void setSSLSessionCacheSize(String cacheSize) {
        this.setProperty("sslSessionCacheSize", cacheSize);
    }

    public String getKeyAlias() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("keyAlias");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getKeyAlias();
        }
        return ret;
    }

    public void setKeyAlias(String alias) {
        this.setProperty("keyAlias", alias);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setKeyAlias(alias);
        }
    }

    public String getSslProtocol() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("sslProtocol");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getProtocol();
        }
        return ret;
    }

    public void setSslProtocol(String sslProtocol) {
        this.setProperty("sslProtocol", sslProtocol);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setProtocol(sslProtocol);
        }
    }

    public String getSslProtocols() {
        ServerSocketFactory factory;
        String ret = (String)this.getProperty("sslProtocols");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getProtocols();
        }
        return ret;
    }

    public void setSslProtocols(String sslProtocols) {
        this.setProperty("sslProtocols", sslProtocols);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setProtocols(sslProtocols);
        }
    }

    public X509Certificate[] getCertificates(Request request) {
        CoyoteRequest cRequest = null;
        if (!(request instanceof CoyoteRequest)) {
            return null;
        }
        cRequest = (CoyoteRequest)request;
        X509Certificate[] certs = (X509Certificate[])cRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            certs = (X509Certificate[])cRequest.getAttribute("org.apache.coyote.request.X509Certificate");
        }
        return certs;
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unregistering - can't stop", t);
        }
    }

    private void findContainer() {
        try {
            ObjectName engName;
            ObjectName parentName = new ObjectName(this.domain + ":" + "type=Service");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding to " + parentName));
            }
            if (this.mserver.isRegistered(parentName)) {
                this.mserver.invoke(parentName, "addConnector", new Object[]{this}, new String[]{"org.apache.catalina.Connector"});
            }
            if (this.mserver.isRegistered(engName = new ObjectName(this.domain + ":" + "type=Engine"))) {
                Object obj = this.mserver.getAttribute(engName, "managedResource");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found engine " + obj + " " + obj.getClass()));
                }
                this.container = (Container)obj;
                this.initialize();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initialized");
                }
                return;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error finding container " + ex));
        }
    }

    public void init() throws Exception {
        if (this.getService() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Already configured");
            }
            return;
        }
        if (this.container == null) {
            this.findContainer();
        }
    }

    public void destroy() throws Exception {
        if (this.oname != null && this.controller == this.oname) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unregister itself " + this.oname));
            }
            Registry.getRegistry().unregisterComponent(this.oname);
        }
        if (this.getService() == null) {
            return;
        }
        this.getService().removeConnector(this);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public String getSelectorThreadImpl() {
        return this.selectorThreadImpl;
    }

    public void setSelectorThreadImpl(String selectorThreadImpl) {
        this.selectorThreadImpl = selectorThreadImpl;
    }
}

