/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public final class UsernamePasswordStore {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static ThreadLocal localUpc = isPerThreadAuth ? new ThreadLocal() : null;
    private static UsernamePasswordStore sharedUpc;
    private final String username;
    private final String password;

    private UsernamePasswordStore(String username, String password) {
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsernamePasswordStore get() {
        if (isPerThreadAuth) {
            return (UsernamePasswordStore)localUpc.get();
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedUpc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(String username, String password) {
        if (isPerThreadAuth) {
            localUpc.set(new UsernamePasswordStore(username, password));
            return;
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            sharedUpc = new UsernamePasswordStore(username, password);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (isPerThreadAuth) {
            localUpc.set(null);
            return;
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            sharedUpc = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void resetThreadLocalOnly() {
        if (isPerThreadAuth) {
            localUpc.set(null);
        }
    }

    public static String getUsername() {
        UsernamePasswordStore ups = UsernamePasswordStore.get();
        if (ups != null) {
            return ups.username;
        }
        return null;
    }

    public static String getPassword() {
        UsernamePasswordStore ups = UsernamePasswordStore.get();
        if (ups != null) {
            return ups.password;
        }
        return null;
    }
}

