/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ClientPasswordLoginModule
implements LoginModule {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    private static final String DEFAULT_REALMNAME = "default";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientPasswordLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private PrincipalImpl userPrincipal;
    public static final String LOGIN_NAME = "j2eelogin.name";
    public static final String LOGIN_PASSWORD = "j2eelogin.password";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            String failure = localStrings.getLocalString("login.nocallback", "Error: no CallbackHandler available to garner authentication information from the user");
            throw new LoginException(failure);
        }
        String uname = UsernamePasswordStore.getUsername();
        String pswd = UsernamePasswordStore.getPassword();
        boolean doSet = false;
        if (uname == null) {
            uname = System.getProperty(LOGIN_NAME);
            doSet = true;
        }
        if (pswd == null) {
            pswd = System.getProperty(LOGIN_PASSWORD);
            doSet = true;
        }
        if (doSet) {
            UsernamePasswordStore.set(uname, pswd);
        }
        if (uname != null && pswd != null) {
            this.username = uname;
            int length = pswd.length();
            char[] dest = new char[length];
            pswd.getChars(0, length, dest, 0);
            this.password = new char[length];
            System.arraycopy(dest, 0, this.password, 0, dest.length);
        } else {
            Callback[] callbacks = new Callback[]{new NameCallback(localStrings.getLocalString("login.username", "ClientPasswordModule username: ")), new PasswordCallback(localStrings.getLocalString("login.password", "ClientPasswordModule password: "), false)};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[0]).getName();
                if (this.username == null) {
                    String fail = localStrings.getLocalString("login.nousername", "No user specified");
                    throw new LoginException(fail);
                }
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmpPassword == null) {
                    tmpPassword = new char[]{};
                }
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                ((PasswordCallback)callbacks[1]).clearPassword();
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                String nocallback = localStrings.getLocalString("login.callback", "Error: Callback not available to garner authentication information from user(CallbackName):");
                throw new LoginException(nocallback + uce.getCallback().toString());
            }
        }
        _logger.log(Level.FINEST, "\t\t[ClientPasswordLoginModule] authentication succeeded");
        this.succeeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add((Principal)this.userPrincipal);
        }
        _logger.log(Level.FINE, "\t\t[ClientPasswordLoginModule] added PrincipalImpl to Subject");
        String realm = DEFAULT_REALMNAME;
        PasswordCredential pc = new PasswordCredential(this.username, new String(this.password), realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }
}

