/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.container.common.spi.OperationsManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private static StringManager sm = StringManager.getManager(UserTransactionImpl.class);
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;
    @Inject
    private Logger _logger;
    private static final boolean debug = false;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private boolean checkEjbAccess;

    public UserTransactionImpl() {
        this(true);
    }

    public UserTransactionImpl(boolean doEjbAccessChecks) {
        this.init();
        this.checkEjbAccess = doEjbAccessChecks;
    }

    private void init() {
        this.initialized = true;
    }

    private void checkUserTransactionMethodAccess(ComponentInvocation inv) throws IllegalStateException, SystemException {
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION && this.checkEjbAccess && !((OperationsManager)inv.container).userTransactionMethodsAllowed(inv)) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.operation_not_allowed"));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        this.transactionManager.begin();
        try {
            if (inv != null) {
                if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                    ((OperationsManager)inv.container).doAfterBegin(inv);
                }
                inv.setTransaction((Object)this.transactionManager.getTransaction());
                this.transactionManager.enlistComponentResources();
            }
        }
        catch (RemoteException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", ex);
            SystemException sysEx = new SystemException(ex.getMessage());
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.commit();
        }
        catch (RemoteException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", ex);
            throw new SystemException();
        }
        finally {
            if (inv != null) {
                inv.setTransaction(null);
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.rollback();
        }
        catch (RemoteException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", ex);
            throw new SystemException();
        }
        finally {
            if (inv != null) {
                inv.setTransaction(null);
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(seconds);
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess(inv);
        }
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    protected void setForTesting(TransactionManager tm, InvocationManager im, Logger l) {
        this.transactionManager = (JavaEETransactionManager)tm;
        this.invocationManager = im;
        this._logger = l;
    }
}

