/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GFLauncher {
    private GFLauncherInfo info;
    private Map<String, String> asenvProps;
    private JavaConfig javaConfig;
    private JvmOptions jvmOptions;
    private Profiler profiler;
    private Map<String, String> sysPropsFromXml;
    private String javaExe;
    private String classpath;
    private List<String> debugOptions;
    private List<String> commandLine;
    private long startTime;
    private static final String JAVA_NATIVE_SYSPROP_NAME = "java.library.path";

    public final GFLauncherInfo getInfo() {
        return this.info;
    }

    public final void launch() throws GFLauncherException {
        try {
            this.startTime = System.currentTimeMillis();
            this.setup();
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException("unknownError", t);
        }
    }

    abstract void internalLaunch() throws GFLauncherException;

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    GFLauncher(GFLauncherInfo info) {
        this.info = info;
    }

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    final List<String> getCommandLine() {
        return this.commandLine;
    }

    final long getStartTime() {
        return this.startTime;
    }

    private void setup() throws GFLauncherException, MiniXmlParserException {
        ASenvPropertyReader pr = new ASenvPropertyReader();
        this.asenvProps = pr.getProps();
        this.info.setup();
        MiniXmlParser parser = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = parser.getDomainName();
        if (GFLauncherUtils.ok((String)domainName)) {
            this.info.setDomainName(parser.getDomainName());
        }
        this.javaConfig = new JavaConfig(parser.getJavaConfig());
        this.setupProfilerAndJvmOptions(parser);
        this.sysPropsFromXml = parser.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        this.debugOptions = this.getDebug();
        this.resolveAllTokens();
        this.setJavaExecutable();
        this.setClasspath();
        this.setCommandLine();
    }

    private void setCommandLine() throws GFLauncherException {
        this.commandLine = new ArrayList<String>();
        this.commandLine.add(this.javaExe);
        this.commandLine.add("-cp");
        this.commandLine.add(this.classpath);
        this.commandLine.addAll(this.debugOptions);
        this.commandLine.addAll(this.jvmOptions.toStringArray());
        this.commandLine.addAll(this.getNativePathCommandLine());
        this.commandLine.add(this.getMainClass());
        this.commandLine.addAll(this.getInfo().getArgsAsList());
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        Map<String, String> envProps = System.getenv();
        Map sysProps = CollectionUtils.propertiesToStringMap((Properties)System.getProperties());
        all.putAll(envProps);
        all.putAll(sysProps);
        all.putAll(this.asenvProps);
        all.putAll(this.sysPropsFromXml);
        all.putAll(this.jvmOptions.getCombinedMap());
        all.putAll(this.profiler.getConfig());
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.jvmOptions.xProps);
        resolver.resolve(this.jvmOptions.xxProps);
        resolver.resolve(this.jvmOptions.plainProps);
        resolver.resolve(this.jvmOptions.sysProps);
        resolver.resolve(this.javaConfig.getMap());
        resolver.resolve(this.profiler.getConfig());
        resolver.resolve(this.debugOptions);
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.javaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    private void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.javaConfig.getEnvClasspath();
        List<File> sysCP = this.javaConfig.getSystemClasspath();
        List<File> prefixCP = this.javaConfig.getPrefixClasspath();
        List<File> suffixCP = this.javaConfig.getSuffixClasspath();
        List<File> profilerCP = this.profiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.classpath = GFLauncherUtils.fileListToPathString(all);
    }

    private boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok((String)filename)) {
            return false;
        }
        File f = new File(filename);
        if (!f.isDirectory()) {
            return false;
        }
        f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
        if (f.exists()) {
            this.javaExe = GFLauncherUtils.absolutize((File)f).getPath();
            return true;
        }
        return false;
    }

    private List<String> getDebug() {
        if (this.info.isDebug() || this.javaConfig.isDebugEnabled()) {
            return this.javaConfig.getDebugOptions();
        }
        return Collections.emptyList();
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser parser) throws MiniXmlParserException {
        this.profiler = new Profiler(parser.getProfilerConfig(), parser.getProfilerJvmOptions(), parser.getProfilerSystemProperties());
        List rawJvmOptions = parser.getJvmOptions();
        if (this.profiler.isEnabled()) {
            rawJvmOptions.addAll(this.profiler.getJvmOptions());
        }
        this.jvmOptions = new JvmOptions(rawJvmOptions);
    }

    private List<String> getNativePathCommandLine() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.profiler.isEnabled()) {
            return list;
        }
        List<File> profilerNativeFiles = this.profiler.getNativePath();
        if (profilerNativeFiles.size() <= 0) {
            return list;
        }
        List nativeFiles = GFLauncherUtils.stringToFiles((String)System.getProperty(JAVA_NATIVE_SYSPROP_NAME));
        nativeFiles.addAll(profilerNativeFiles);
        String nativeCommand = "-Djava.library.path=";
        nativeCommand = nativeCommand + GFLauncherUtils.fileListToPathString((List)nativeFiles);
        list.add(nativeCommand);
        return list;
    }
}

