/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.RemoteCommandParser;
import com.sun.enterprise.admin.cli.deployment.FileUploadUtil;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommand {
    private static final RemoteCommand INSTANCE = new RemoteCommand();
    public static final boolean TRACE = Boolean.getBoolean("trace");

    RemoteCommand() {
    }

    public static RemoteCommand getInstance() {
        return INSTANCE;
    }

    public void handleRemoteCommand(String[] args) {
        this.handleRemoteCommand(args, "hk2-cli", null);
    }

    public void handleRemoteCommand(String[] args, String responseFormatType, OutputStream userOut) {
        block16: {
            if (args.length == 0) {
                System.err.println("usage : asadmin <command> [parameters]");
                return;
            }
            try {
                RemoteCommandParser rcp = new RemoteCommandParser(args);
                if (TRACE) {
                    System.out.println("RemoteCommandParser: " + rcp);
                }
                Map params = rcp.getOptions();
                Vector operands = rcp.getOperands();
                boolean uploadFile = this.getUploadFile((String)params.get("upload"), rcp.getCommandName(), operands.size() > 0 ? (String)operands.firstElement() : (String)params.get("path"));
                File fileName = null;
                String hostName = params.get("host") == null ? "localhost" : (String)params.get("host");
                String hostPort = params.get("port") == null ? "8080" : (String)params.get("port");
                String secure = params.get("secure") == null ? "false" : (String)params.get("secure");
                boolean isSecure = Boolean.parseBoolean(secure);
                String user = params.get("user") == null ? "" : (String)params.get("user");
                String password = "";
                if (params.get("passwordfile") != null) {
                    Map<String, String> passwordOptions = CLIUtil.readPasswordFileOptions((String)params.get("passwordfile"));
                    password = passwordOptions.get("password");
                }
                String uriConnection = "/__asadmin/" + rcp.getCommandName();
                for (Map.Entry param : params.entrySet()) {
                    String paramName = (String)param.getKey();
                    if (paramName.equals("host") || paramName.equals("port") || paramName.equals("upload") || paramName.equals("user") || paramName.equals("passwordfile") || paramName.equals("secure")) continue;
                    try {
                        String paramValue = (String)param.getValue();
                        if (paramName.equals("path")) {
                            fileName = new File(paramValue);
                            paramValue = this.getFileParam(uploadFile, fileName);
                        }
                        uriConnection = uriConnection + "?" + paramName + "=" + URLEncoder.encode(paramValue, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.err.println("Error encoding " + paramName + ", parameter value will be ignored");
                    }
                }
                for (int ii = 0; ii < operands.size(); ++ii) {
                    String operand = (String)operands.get(ii);
                    if (rcp.getCommandName().equals("deploy")) {
                        fileName = new File(operand);
                        String fileParam = this.getFileParam(uploadFile, fileName);
                        uriConnection = uriConnection + "?path=" + URLEncoder.encode(fileParam, "UTF-8");
                        break;
                    }
                    uriConnection = uriConnection + "?DEFAULT=" + URLEncoder.encode(operand, "UTF-8");
                }
                if (TRACE) {
                    System.out.println("Connecting to " + uriConnection);
                }
                try {
                    InputStream in;
                    HttpURLConnection urlConnection;
                    HttpConnectorAddress url = new HttpConnectorAddress(hostName, Integer.parseInt(hostPort), isSecure);
                    url.setAuthenticationInfo(new AuthenticationInfo(user, password));
                    if (fileName != null && uploadFile) {
                        if (fileName.exists()) {
                            urlConnection = FileUploadUtil.upload(url.toURL(uriConnection).toString(), fileName);
                            in = urlConnection.getInputStream();
                            this.handleResponse(params, in, urlConnection.getResponseCode());
                            break block16;
                        }
                        throw new Exception("File " + fileName.getName() + " does not exist.");
                    }
                    urlConnection = (HttpURLConnection)url.openConnection(uriConnection);
                    urlConnection.setRequestProperty("User-Agent", responseFormatType);
                    urlConnection.connect();
                    in = urlConnection.getInputStream();
                    this.handleResponse(params, in, urlConnection.getResponseCode(), userOut);
                }
                catch (IOException e) {
                    System.err.println("Cannot connect to host, is server up ?");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    String getFileParam(boolean uploadFile, File fileName) {
        if (fileName == null) {
            return null;
        }
        String paramValue = fileName.getName();
        if (fileName.exists() && !uploadFile) {
            try {
                paramValue = fileName.getCanonicalPath();
            }
            catch (IOException ioe) {
                paramValue = fileName.getAbsolutePath();
            }
        }
        return paramValue;
    }

    boolean getUploadFile(String uploadOption, String commandName, String fileName) {
        boolean uploadFile = Boolean.parseBoolean(uploadOption);
        if (fileName != null && commandName.equals("deploy")) {
            if (new File(fileName).isDirectory()) {
                uploadFile = false;
            } else if (uploadOption == null) {
                uploadFile = true;
            }
        }
        return uploadFile;
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            this.copyStream(in, userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException {
        if (TRACE) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.copyStream(in, baos);
            System.out.println("Response\n=====");
            System.out.println(baos);
            System.out.println("=====");
            in = new ByteArrayInputStream(baos.toByteArray());
        }
        if (code == 200) {
            Manifest m = this.getManifest(in);
            if (m == null) {
                return;
            }
            if (params.size() == 1 && params.get("help") != null) {
                this.processHelp(m);
            } else {
                this.processMessage(m);
            }
        } else {
            System.out.println("Failed : error code " + code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(InputStream is) {
        try {
            Manifest m = new Manifest();
            m.read(is);
            if (Boolean.getBoolean("dump.manifest")) {
                m.write(System.out);
            }
            Manifest manifest = m;
            return manifest;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void processHelp(Manifest m) {
        StringTokenizer token;
        System.out.println("");
        System.out.println(m.getMainAttributes().getValue("message"));
        System.out.println("");
        System.out.println("Parameters : ");
        Attributes attr = m.getMainAttributes();
        String keys = attr.getValue("keys");
        if (keys != null && (token = new StringTokenizer(keys, ",")).hasMoreTokens()) {
            while (token.hasMoreTokens()) {
                String property = token.nextToken();
                String name = attr.getValue(property + "_name");
                String value = attr.getValue(property + "_value");
                System.out.println("\t" + name + " : " + value);
            }
        }
    }

    private void processMessage(Manifest m) {
        String exitCode = m.getMainAttributes().getValue("exit-code");
        String message = m.getMainAttributes().getValue("message");
        if (exitCode != null) {
            System.out.println(exitCode + " : " + message);
            if (!exitCode.equalsIgnoreCase("Success")) {
                return;
            }
        } else {
            System.out.println(message);
        }
        this.processOneLevel("", null, m, m.getMainAttributes());
    }

    private void processOneLevel(String prefix, String key, Manifest m, Attributes attr) {
        String children;
        StringTokenizer token;
        String keys = attr.getValue("keys");
        if (keys != null && (token = new StringTokenizer(keys, ",")).hasMoreTokens()) {
            System.out.print(prefix + "properties=(");
            while (token.hasMoreTokens()) {
                String property = token.nextToken();
                String name = attr.getValue(property + "_name");
                String value = attr.getValue(property + "_value");
                System.out.print(name + "=" + value);
                if (!token.hasMoreElements()) continue;
                System.out.print(",");
            }
            System.out.println(")");
        }
        if ((children = attr.getValue("children")) == null) {
            return;
        }
        String childrenType = attr.getValue("children-type");
        StringTokenizer token2 = new StringTokenizer(children, ",");
        while (token2.hasMoreTokens()) {
            String container = token2.nextToken();
            int index = key == null ? 0 : key.length() + 1;
            System.out.println(prefix + childrenType + " : " + container.substring(index));
            Attributes childAttr = m.getAttributes(container);
            this.processOneLevel(prefix + "\t", container, m, childAttr);
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }
}

