/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class RemoteCommandParser {
    private String commandName = null;
    private Map<String, String> optionsMap = new HashMap<String, String>();
    private Vector<String> Operands = new Vector();
    private static final String SHORT_OPTION_REGEXP = "^-[\\w?]+";
    private static final String SHORT_OPTION_ARGUMENT_REGEXP = "^-[\\w?](=.*)";
    private final String LONG_OPTION_REGEXP = "^--\\w[-\\w]*(=.*)*";
    private static final String COMMAND_NAME_REGEXP = "^[a-z\\-][a-z0-9\\-\\_\\ ]*$";
    private static final String SHORT_OPTION_HELP_REGEXP = "-\\w*[?]\\w*";
    private static final String HELP_OPTION = "--help";
    private static final String BOOLEAN_NO_OPTION = "--no-";
    private static final String BOOLEAN = "boolean";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public RemoteCommandParser() {
    }

    public RemoteCommandParser(String[] args) throws CommandValidationException {
        this.parseCommandLine(args);
    }

    private void parseCommandLine(String[] args) throws CommandValidationException {
        this.commandName = args[0];
        for (int ii = 1; ii < args.length; ++ii) {
            ii = args[ii].matches(SHORT_OPTION_REGEXP) || args[ii].matches(SHORT_OPTION_ARGUMENT_REGEXP) ? this.insertShortOption(args, ii) : (args[ii].matches("^--\\w[-\\w]*(=.*)*") ? this.insertLongOption(args, ii) : this.insertOperands(Arrays.asList(args).listIterator(ii)));
        }
    }

    private int verifyShortOptions(String[] args, int ii) throws CommandValidationException {
        if (!args[ii].matches(SHORT_OPTION_REGEXP) && !args[ii].matches(SHORT_OPTION_ARGUMENT_REGEXP)) {
            throw new CommandValidationException("NoSuchOption " + args[ii]);
        }
        int index = this.insertShortOption(args, ii);
        return index;
    }

    private void insertShortOptionsGroup(String sOptions) throws CommandValidationException {
        for (int jj = 1; jj < sOptions.length(); ++jj) {
            this.optionsMap.put(String.valueOf(sOptions.charAt(jj)), "");
        }
    }

    private int insertShortOption(String[] args, int ii) throws CommandValidationException {
        if (args[ii].length() > 2) {
            int index = args[ii].indexOf(61);
            if (index == -1) {
                this.insertShortOptionsGroup(args[ii]);
            } else {
                this.optionsMap.put(String.valueOf(args[ii].charAt(1)), args[ii].substring(index + 1));
            }
        } else if (ii + 1 < args.length) {
            if (args[ii + 1].startsWith("-")) {
                this.optionsMap.put(String.valueOf(args[ii].charAt(1)), "");
            } else {
                this.optionsMap.put(String.valueOf(args[ii].charAt(1)), args[ii + 1]);
                ++ii;
            }
        } else {
            this.optionsMap.put(args[ii].substring(1), "");
        }
        return ii;
    }

    private int insertLongOption(String[] args, int ii) throws CommandValidationException {
        int index = args[ii].indexOf(61);
        if (index == -1) {
            if (args[ii].startsWith(BOOLEAN_NO_OPTION)) {
                if (args[ii + 1].startsWith("-")) {
                    throw new CommandValidationException("Invalid command syntax");
                }
                this.optionsMap.put(args[ii].substring(BOOLEAN_NO_OPTION.length()), FALSE);
            } else if (ii + 1 < args.length) {
                if (args[ii + 1].startsWith("-")) {
                    this.optionsMap.put(args[ii].substring(2), "");
                } else {
                    this.optionsMap.put(args[ii].substring(2), args[ii + 1]);
                    ++ii;
                }
            } else {
                this.optionsMap.put(args[ii].substring(2), "");
            }
        } else {
            this.optionsMap.put(args[ii].substring(2, index), args[ii].substring(index + 1));
        }
        return ii;
    }

    private int insertOperands(ListIterator operandIter) throws CommandValidationException {
        try {
            if (!((String)operandIter.next()).equals("--")) {
                this.Operands.add((String)operandIter.previous());
                operandIter.next();
            }
            while (operandIter.hasNext()) {
                this.Operands.add((String)operandIter.next());
            }
        }
        catch (NoSuchElementException nsee) {
            throw new CommandValidationException(nsee);
        }
        return operandIter.nextIndex();
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Map getOptions() {
        return this.optionsMap;
    }

    public Vector getOperands() {
        return this.Operands;
    }

    public String toString() {
        return "\n**********\nname = " + this.commandName + "\nOptions = " + this.optionsMap + "\nOperands = " + this.Operands + "\n**********\n";
    }
}

