/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.RemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import java.util.Set;

public class StopDomainCommand
extends Command {
    private boolean terse;
    private boolean echo;
    private File domainsDir;
    private File domainRootDir;
    private String domainName;
    private File domainXml;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.getDomainRootDir();
        this.getDomainXml();
        this.domainRootDir = GFLauncherUtils.absolutize((File)this.domainRootDir);
        Integer[] ports = null;
        try {
            MiniXmlParser parser = new MiniXmlParser(this.domainXml);
            Set portsSet = parser.getAdminPorts();
            ports = portsSet.toArray(new Integer[portsSet.size()]);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandValidationException(strings.get("StopDomain.parserError", new Object[]{ex}), ex);
        }
        RemoteCommand rc = RemoteCommand.getInstance();
        String[] args = new String[]{"stop-domain", "--port", ports[0].toString()};
        try {
            rc.handleRemoteCommand(args);
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.getLocalizedMessage());
            System.exit(1);
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.firstElement();
        }
        this.terse = this.getBooleanOption("terse");
        this.echo = this.getBooleanOption("echo");
        String domaindir = this.getOption("domaindir");
        if (StopDomainCommand.ok(domaindir)) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
        if (this.echo) {
            CLILogger.getInstance().printMessage("ECHO: " + this.toString());
        }
        return true;
    }

    private void getDomainRootDir() throws CommandValidationException {
        Map props = new ASenvPropertyReader().getProps();
        if (this.domainsDir == null) {
            this.domainsDir = new File((String)props.get("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        this.domainRootDir = this.domainName != null ? new File(this.domainsDir, this.domainName) : this.getTheOneAndOnlyDomain(this.domainsDir);
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", new Object[]{this.domainRootDir}));
        }
    }

    private void getDomainXml() throws CommandValidationException {
        this.domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!this.domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", new Object[]{this.domainXml}));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

