/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler.modules;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.AttributeInfo;
import com.sun.org.apache.commons.modeler.BaseModelMBean;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.Registry;
import com.sun.org.apache.commons.modeler.modules.MbeansSourceMBean;
import com.sun.org.apache.commons.modeler.modules.ModelerSource;
import com.sun.org.apache.commons.modeler.util.DomUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MbeansSource
extends ModelerSource
implements MbeansSourceMBean {
    private static Log log = LogFactory.getLog(MbeansSource.class);
    Registry registry;
    String type;
    boolean loading = true;
    List mbeans = new ArrayList();
    static boolean loaderLoaded = false;
    private Document document;
    private HashMap object2Node = new HashMap();
    long lastUpdate;
    long updateInterval = 10000L;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public String getLocation() {
        return this.location;
    }

    public List getMBeans() {
        return this.mbeans;
    }

    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void start() throws Exception {
        this.registry.invoke(this.mbeans, "start", false);
    }

    public void stop() throws Exception {
        this.registry.invoke(this.mbeans, "stop", false);
    }

    public void init() throws Exception {
        if (this.mbeans == null) {
            this.execute();
        }
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        this.registry.invoke(this.mbeans, "init", false);
    }

    public void destroy() throws Exception {
        this.registry.invoke(this.mbeans, "destroy", false);
    }

    public void load() throws Exception {
        this.execute();
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            InputStream stream = this.getInputStream();
            long t1 = System.currentTimeMillis();
            this.document = DomUtil.readXml(stream);
            Element descriptorsN = this.document.getDocumentElement();
            if (descriptorsN == null) {
                log.error((Object)"No descriptors found");
                return;
            }
            Node firstMbeanN = DomUtil.getChild((Node)descriptorsN, null);
            if (firstMbeanN == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No child " + descriptorsN));
                }
                firstMbeanN = descriptorsN;
            }
            MBeanServer server = Registry.getServer();
            if (!loaderLoaded) {
                ObjectName defaultLoader = new ObjectName("modeler", "loader", "modeler");
                MLet mlet = new MLet(new URL[0], this.getClass().getClassLoader());
                server.registerMBean(mlet, defaultLoader);
                loaderLoaded = true;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                Node firstN;
                String nodeName = mbeanN.getNodeName();
                if ("mbean".equals(nodeName) || "MLET".equals(nodeName)) {
                    Node firstAttN;
                    Node constructorN;
                    String code = DomUtil.getAttribute(mbeanN, "code");
                    String objectName = DomUtil.getAttribute(mbeanN, "objectName");
                    if (objectName == null) {
                        objectName = DomUtil.getAttribute(mbeanN, "name");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing mbean objectName=" + objectName + " code=" + code));
                    }
                    if ((constructorN = DomUtil.getChild(mbeanN, "constructor")) == null) {
                        constructorN = mbeanN;
                    }
                    this.processArg(constructorN);
                    try {
                        ObjectName oname = new ObjectName(objectName);
                        if (!server.isRegistered(oname)) {
                            String modelMBean = BaseModelMBean.class.getName();
                            server.createMBean(modelMBean, oname, new Object[]{code, this}, new String[]{String.class.getName(), ModelerSource.class.getName()});
                            this.mbeans.add(oname);
                        }
                        this.object2Node.put(oname, mbeanN);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Error creating mbean " + objectName), (Throwable)ex);
                    }
                    Node descN = firstAttN = DomUtil.getChild(mbeanN, "attribute");
                    while (descN != null) {
                        this.processAttribute(server, descN, objectName);
                        descN = DomUtil.getNext(descN);
                    }
                } else if ("jmx-operation".equals(nodeName)) {
                    String name = DomUtil.getAttribute(mbeanN, "objectName");
                    if (name == null) {
                        name = DomUtil.getAttribute(mbeanN, "name");
                    }
                    String operation = DomUtil.getAttribute(mbeanN, "operation");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing invoke objectName=" + name + " code=" + operation));
                    }
                    try {
                        ObjectName oname = new ObjectName(name);
                        this.processArg(mbeanN);
                        server.invoke(oname, operation, null, null);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error in invoke " + name + " " + operation));
                    }
                }
                ManagedBean managed = new ManagedBean();
                DomUtil.setAttributes(managed, mbeanN);
                Node descN = firstN = DomUtil.getChild(mbeanN, "attribute");
                while (descN != null) {
                    AttributeInfo ci = new AttributeInfo();
                    DomUtil.setAttributes(ci, descN);
                    managed.addAttribute(ci);
                    descN = DomUtil.getNext(descN);
                }
                mbeanN = DomUtil.getNext(mbeanN, null, 1);
            }
            long t2 = System.currentTimeMillis();
            log.info((Object)("Reading mbeans  " + (t2 - t1)));
            this.loading = false;
        }
        catch (Exception ex) {
            log.error((Object)"Error reading mbeans ", (Throwable)ex);
        }
    }

    public void updateField(ObjectName oname, String name, Object value) {
        String oldValue;
        if (this.loading) {
            return;
        }
        Node n = (Node)this.object2Node.get(oname);
        if (n == null) {
            log.info((Object)("Node not found " + oname));
            return;
        }
        Node attNode = DomUtil.findChildWithAtt(n, "attribute", "name", name);
        if (attNode == null) {
            attNode = n.getOwnerDocument().createElement("attribute");
            DomUtil.setAttribute(attNode, "name", name);
            n.appendChild(attNode);
        }
        if ((oldValue = DomUtil.getAttribute(attNode, "value")) != null) {
            DomUtil.removeAttribute(attNode, "value");
        }
        DomUtil.setText(attNode, value.toString());
    }

    public void save() {
        long time = System.currentTimeMillis();
        if (this.location != null && time - this.lastUpdate > this.updateInterval) {
            this.lastUpdate = time;
            try {
                FileOutputStream fos = new FileOutputStream(this.location);
                DomUtil.writeXml(this.document, fos);
            }
            catch (TransformerException e) {
                log.error((Object)"Error writing");
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Error writing", (Throwable)e);
            }
        }
    }

    private void processAttribute(MBeanServer server, Node descN, String objectName) {
        String attName = DomUtil.getAttribute(descN, "name");
        String value = DomUtil.getAttribute(descN, "value");
        String type = null;
        if (value == null) {
            value = DomUtil.getContent(descN);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set attribute " + objectName + " " + attName + " " + value));
            }
            ObjectName oname = new ObjectName(objectName);
            if (type == null) {
                type = this.registry.getType(oname, attName);
            }
            if (type == null) {
                log.info((Object)("Can't find attribute " + objectName + " " + attName));
            } else {
                Object valueO = this.registry.convertValue(type, value);
                server.setAttribute(oname, new Attribute(attName, valueO));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error processing attribute " + objectName + " " + attName + " " + value), (Throwable)ex);
        }
    }

    private void processArg(Node mbeanN) {
        Node firstArgN;
        Node argN = firstArgN = DomUtil.getChild(mbeanN, "arg");
        while (argN != null) {
            String type = DomUtil.getAttribute(argN, "type");
            String value = DomUtil.getAttribute(argN, "value");
            if (value == null) {
                value = DomUtil.getContent(argN);
            }
            argN = DomUtil.getNext(argN);
        }
    }
}

