/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.connectors.spi.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.resource.deployer.ConnectorConnectionPoolDeployer;
import com.sun.enterprise.resource.deployer.ConnectorResourceDeployer;
import com.sun.enterprise.resource.deployer.JdbcConnectionPoolDeployer;
import com.sun.enterprise.resource.deployer.JdbcResourceDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class ResourceDeployerFactory {
    private ResourceDeployer connectorResourceDeployer_ = new ConnectorResourceDeployer();
    private ResourceDeployer connectorConnectionPoolDeployer_ = new ConnectorConnectionPoolDeployer();
    private ResourceDeployer jdbcResourceDeployer_ = new JdbcResourceDeployer();
    private ResourceDeployer JdbcConnectionPoolDeployer_ = new JdbcConnectionPoolDeployer();
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(ResourceDeployerFactory.class);

    public ResourceDeployer getResourceDeployer(String type) throws Exception {
        ResourceDeployer deployer = null;
        if (type.equals("jdbc")) {
            deployer = this.jdbcResourceDeployer_;
        } else if (type.equals("cr")) {
            deployer = this.connectorResourceDeployer_;
        } else if (type.equals("ccp")) {
            deployer = this.connectorConnectionPoolDeployer_;
        } else if (type.equals("jcp")) {
            deployer = this.JdbcConnectionPoolDeployer_;
        } else {
            String msg = localStrings.getString("resource.deployment.resource_type_not_implemented", (Object)type);
            throw new Exception(msg);
        }
        return deployer;
    }

    public ResourceDeployer getResourceDeployer(Object resource) throws Exception {
        ResourceDeployer deployer = null;
        if (resource instanceof JdbcResource) {
            deployer = this.jdbcResourceDeployer_;
        } else if (resource instanceof ConnectorResource) {
            deployer = this.connectorResourceDeployer_;
        } else if (resource instanceof ConnectorConnectionPool) {
            deployer = this.connectorConnectionPoolDeployer_;
        } else if (resource instanceof JdbcConnectionPool) {
            deployer = this.JdbcConnectionPoolDeployer_;
        } else {
            String msg = localStrings.getString("resource.deployment.resource_type_not_implemented", resource);
            throw new ConnectorRuntimeException(msg);
        }
        return deployer;
    }
}

