/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import sun.misc.BASE64Encoder;

public class FileUploadUtil {
    private static final String JSR88 = "jsr88";

    public static String uploadToServlet(String host, String port, String user, String password, Archive module) throws Exception {
        Socket socket = null;
        BufferedInputStream bis = null;
        try {
            String remotePath;
            String fileName = null;
            if (module instanceof MemoryMappedArchive) {
                byte[] bytes = ((MemoryMappedArchive)((Object)module)).getByteArray();
                bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
                File tmpFile = File.createTempFile(JSR88, null);
                tmpFile.deleteOnExit();
                fileName = tmpFile.getName();
            } else {
                File f = new File(module.getURI().getPath());
                bis = new BufferedInputStream(new FileInputStream(f));
                fileName = f.getName();
            }
            String path = "/web1/uploadServlet?file=" + URLEncoder.encode(fileName, "UTF-8");
            socket = new Socket(host, Integer.parseInt(port));
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            wr.write("POST " + path + " HTTP/1.0\r\n");
            wr.write("Content-Length: " + bis.available() + "\r\n");
            wr.write("Content-Type: application/octet-stream\r\n");
            byte[] encodedPassword = (user + ":" + password).getBytes();
            BASE64Encoder encoder = new BASE64Encoder();
            wr.write("Authorization: Basic " + encoder.encode(encodedPassword) + "\r\n");
            wr.write("\r\n");
            wr.flush();
            byte[] buffer = new byte[65536];
            int i = bis.read(buffer);
            while (i > 0) {
                out.write(buffer, 0, i);
                i = bis.read(buffer);
            }
            out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            Vector<String> v = new Vector<String>();
            for (int timeoutCounter = 0; timeoutCounter < 120; ++timeoutCounter) {
                boolean finished = false;
                while (reader.ready()) {
                    String curLine = reader.readLine();
                    v.add(curLine);
                    if (!curLine.startsWith("SUCCESS:")) continue;
                    finished = true;
                }
                if (finished) break;
                Thread.sleep(500L);
            }
            if (v.size() == 0) {
                throw new Exception("Upload file failed: no server response received");
            }
            boolean isData = false;
            int i2 = 0;
            String responseString = null;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String responseCode;
                String curElement = (String)e.nextElement();
                if (i2 == 0 && !(responseCode = curElement.substring(curElement.indexOf(" ") + 1)).startsWith("200")) {
                    throw new Exception("HTTP connection failed: " + responseCode);
                }
                if (curElement.equals("")) {
                    isData = true;
                } else if (isData) {
                    responseString = curElement;
                    break;
                }
                ++i2;
            }
            if (responseString == null) {
                throw new Exception("Upload file failed: no server response received");
            }
            if (!responseString.startsWith("SUCCESS:")) {
                throw new Exception("Upload file failed: " + responseString);
            }
            String string = remotePath = responseString.substring(8);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }
}

