/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.impl.Utils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.PropertiesTokenizer;
import com.sun.logging.LogDomains;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.UnsatisfiedDepedencyException;

@Service
public class CommandRunner {
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunner.class);
    public static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");
    @Inject
    Habitat habitat;

    public void doCommand(String commandName, Properties parameters, ActionReport report) {
        AdminCommand handler = this.getCommand(commandName, report, logger);
        if (handler == null) {
            return;
        }
        this.doCommand(commandName, handler, parameters, report);
    }

    public void doCommand(String commandName, final AdminCommand command, final Properties parameters, final ActionReport report) {
        if (parameters.size() == 1 && parameters.get("help") != null) {
            this.usage(commandName, command, report);
            return;
        }
        report.setActionDescription(commandName + " AdminCommand");
        final AdminCommandContext context = new AdminCommandContext(LogDomains.getLogger((String)"javax.enterprise.system.tools.admin"), report, parameters);
        InjectionManager<Param> injectionMgr = new InjectionManager<Param>(){

            protected boolean isOptional(Param annotation) {
                return annotation.optional();
            }

            protected Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                String value;
                Param param = target.getAnnotation(Param.class);
                if (param.primary() && (value = parameters.getProperty("DEFAULT")) != null) {
                    parameters.setProperty(CommandRunner.this.getParamName(param, target), value);
                    return value;
                }
                String paramValueStr = CommandRunner.this.getPropertiesValue(parameters, CommandRunner.this.getParamName(param, target), true);
                Object paramVal = null;
                try {
                    paramVal = CommandRunner.this.getParamValue(type, paramValueStr);
                }
                catch (Exception e) {
                    logger.severe(e.getMessage());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(e.getMessage());
                    report.setFailureCause((Throwable)e);
                }
                return paramVal;
            }
        };
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        try {
            injectionMgr.inject((Object)command, Param.class);
        }
        catch (UnsatisfiedDepedencyException e) {
            Param param = e.getUnsatisfiedElement().getAnnotation(Param.class);
            String paramName = this.getParamName(param, e.getUnsatisfiedElement());
            String paramDesc = this.getParamDescription(localStrings, i18n_key, paramName, e.getUnsatisfiedElement());
            String errorMsg = paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter : {2}", new Object[]{commandName, paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{commandName, paramName});
            logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
            return;
        }
        catch (ComponentException e) {
            logger.severe(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            report.setFailureCause((Throwable)e);
        }
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                command.execute(context);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        command.execute(context);
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "{0} launch successful", new Object[]{commandName}));
        }
    }

    protected String getParamDescription(LocalStringManagerImpl localStrings, String i18nKey, String paramName, AnnotatedElement annotated) {
        I18n i18n = annotated.getAnnotation(I18n.class);
        String paramDesc = i18n == null ? localStrings.getLocalString(i18nKey + "." + paramName, null) : localStrings.getLocalString(i18n.value(), null);
        if (paramDesc == null) {
            paramDesc = adminStrings.getLocalString("adapter.nodesc", "no description provided");
        }
        return paramDesc;
    }

    protected String getParamName(Param param, AnnotatedElement annotated) {
        if (param.name().equals("")) {
            if (annotated instanceof Field) {
                return ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                return ((Method)annotated).getName().substring(3).toLowerCase();
            }
        } else {
            return param.name();
        }
        return "";
    }

    Object getParamValue(Class type, String paramValStr) {
        Object paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = this.parseProperties(paramValStr);
        }
        return paramValue;
    }

    String getPropertiesValue(Properties props, String key, boolean ignoreCase) {
        if (ignoreCase) {
            for (Object propObj : props.keySet()) {
                String propName = (String)propObj;
                if (!propName.equalsIgnoreCase(key)) continue;
                return props.getProperty(propName);
            }
        }
        return props.getProperty(key);
    }

    private AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
        if (command == null) {
            String msg = !this.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName});
            report.setMessage(msg);
            Utils.getDefaultLogger().info(msg);
        }
        return command;
    }

    public void usage(String commandName, AdminCommand command, ActionReport report) {
        report.setActionDescription(commandName + " help");
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = "";
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        report.setMessage(localStrings.getLocalString(i18nKey, null));
        for (Field field : command.getClass().getDeclaredFields()) {
            this.addParamUsage(report, localStrings, i18nKey, field);
        }
        for (AccessibleObject accessibleObject : command.getClass().getDeclaredMethods()) {
            this.addParamUsage(report, localStrings, i18nKey, accessibleObject);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void addParamUsage(ActionReport report, LocalStringManagerImpl localStrings, String i18nKey, AnnotatedElement annotated) {
        Param param = annotated.getAnnotation(Param.class);
        if (param != null) {
            String paramName = this.getParamName(param, annotated);
            report.getTopMessagePart().addProperty(paramName, this.getParamDescription(localStrings, i18nKey, paramName, annotated));
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    Properties parseProperties(String propsString) {
        Properties properties = new Properties();
        if (propsString != null) {
            PropertiesTokenizer stoken = new PropertiesTokenizer(propsString, ":");
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                if (token.indexOf("=") == -1) continue;
                PropertiesTokenizer nameTok = new PropertiesTokenizer(token, "=");
                if (nameTok.countTokens() == 2) {
                    properties.setProperty(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                    continue;
                }
                throw new IllegalArgumentException(adminStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax."));
            }
        }
        return properties;
    }
}

