/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-file-user")
@Scoped(value=PerLookup.class)
@I18n(value="create.file.user")
public class CreateFileUser
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateFileUser.class);
    @Param(name="userpasswordfile")
    String passwordFile;
    @Param(name="groups", optional=true)
    String groups;
    @Param(name="authrealmname", optional=true)
    String authRealmName;
    @Param(optional=true)
    String target;
    @Param(name="username", primary=true)
    String userName;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService securityService = config.getSecurityService();
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals("file")) continue;
            fileAuthRealm = authRealm;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("create.fileuser.filerealm.notfound", "There is no File realm to perform this operation"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("create.fileuser.keyfile.notfound", "There is no physical file associated with this Filerealm"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String password = this.fetchPassword();
        if (password == null) {
            report.setMessage(localStrings.getLocalString("create.fileuser.keyfile.notreadable", "User password cannot be read from the file associated with this Filerealm"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("create.fileuser.realm.notsupported", "Configured FileRealm is not supported."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            fr = new FileRealm(keyFile);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("create.fileuser.realm.corrupted", "Configured FileRealm is corrupted."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("create.fileuser.realm.notsupported", "Configured FileRealm is not supported."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            User user = fr.getUser(this.userName);
        }
        catch (NoSuchUserException e) {
            // empty catch block
        }
        try {
            String[] groups1 = new String[]{this.groups};
            System.out.println("Before add user");
            System.out.println("userName = " + this.userName + " , " + "password = " + password + " , " + "groups = " + groups1);
            fr.addUser(this.userName, password, groups1);
            fr.writeKeyFile(keyFile);
            System.out.println("After add user");
        }
        catch (Exception e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.fileuser.useradd.failed", "Adding User to this Filerealm failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchPassword() {
        String password = null;
        File passwdFile = new File(this.passwordFile);
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(passwdFile));
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String entry = (String)en.nextElement();
                if (!entry.equals("AS_ADMIN_USERPASSWORD")) continue;
                password = prop.getProperty(entry);
                break;
            }
            String string = password;
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
    }
}

