/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JDBCConnectionPoolManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.connection.pool")
public class CreateJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcConnectionPool.class);
    @Param(name="datasourceclassname")
    String datasourceclassname;
    @Param(name="restype", optional=true)
    String restype;
    @Param(name="steadypoolsize", optional=true)
    String steadypoolsize = "8";
    @Param(name="maxpoolsize", optional=true)
    String maxpoolsize = "32";
    @Param(name="maxwait", optional=true)
    String maxwait = "60000";
    @Param(name="poolresize", optional=true)
    String poolresize = "2";
    @Param(name="idletimeout", optional=true)
    String idletimeout = "300";
    @Param(name="isolationlevel", optional=true)
    String isolationlevel;
    @Param(name="isisolationguaranteed", optional=true)
    String isisolationguaranteed = Boolean.TRUE.toString();
    @Param(name="isconnectvalidatereq", optional=true)
    String isconnectvalidatereq = Boolean.FALSE.toString();
    @Param(name="validationmethod", optional=true)
    String validationmethod = "auto-commit";
    @Param(name="validationtable", optional=true)
    String validationtable;
    @Param(name="failconnection", optional=true)
    String failconnection = Boolean.FALSE.toString();
    @Param(name="allownoncomponentcallers", optional=true)
    String allownoncomponentcallers = Boolean.FALSE.toString();
    @Param(name="nontransactionalconnections", optional=true)
    String nontransactionalconnections = Boolean.FALSE.toString();
    @Param(name="validateatmostonceperiod", optional=true)
    String validateatmostonceperiod = "0";
    @Param(name="leaktimeout", optional=true)
    String leaktimeout = "0";
    @Param(name="leakreclaim", optional=true)
    String leakreclaim = Boolean.FALSE.toString();
    @Param(name="creationretryattempts", optional=true)
    String creationretryattempts = "0";
    @Param(name="creationretryinterval", optional=true)
    String creationretryinterval = "10";
    @Param(name="statementtimeout", optional=true)
    String statementtimeout = "-1";
    @Param(name="lazyconnectionenlistment", optional=true)
    String lazyconnectionenlistment = Boolean.FALSE.toString();
    @Param(name="lazyconnectionassociation", optional=true)
    String lazyconnectionassociation = Boolean.FALSE.toString();
    @Param(name="associatewiththread", optional=true)
    String associatewiththread = Boolean.FALSE.toString();
    @Param(name="matchconnections", optional=true)
    String matchconnections = Boolean.FALSE.toString();
    @Param(name="maxconnectionusagecount", optional=true)
    String maxconnectionusagecount = "0";
    @Param(name="wrapjdbcobjects", optional=true)
    String wrapjdbcobjects = Boolean.FALSE.toString();
    @Param(name="description", optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Resources resources;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("name", this.jdbc_connection_pool_id);
        attrList.put("datasource-classname", this.datasourceclassname);
        attrList.put("description", this.description);
        attrList.put("res-type", this.restype);
        attrList.put("steady-pool-size", this.steadypoolsize);
        attrList.put("max-pool-size", this.maxpoolsize);
        attrList.put("max-wait-time-in-millis", this.maxwait);
        attrList.put("pool-resize-quantity", this.poolresize);
        attrList.put("idle-timeout-in-seconds", this.idletimeout);
        attrList.put("transaction-isolation-level", this.isolationlevel);
        attrList.put("is-isolation-level-guaranteed", this.isisolationguaranteed);
        attrList.put("is-connection-validation-required", this.isconnectvalidatereq);
        attrList.put("connection-validation-method", this.validationmethod);
        attrList.put("validation-table-name", this.validationtable);
        attrList.put("fail-all-connections", this.failconnection);
        attrList.put("non-transactional-connections", this.nontransactionalconnections);
        attrList.put("allow-non-component-callers", this.allownoncomponentcallers);
        attrList.put("validate-atmost-once-period-in-seconds", this.validateatmostonceperiod);
        attrList.put("connection-leak-timeout-in-seconds", this.leaktimeout);
        attrList.put("connection-leak-reclaim", this.leakreclaim);
        attrList.put("connection-creation-retry-attempts", this.creationretryattempts);
        attrList.put("connection-creation-retry-interval", this.creationretryinterval);
        attrList.put("statement-timeout", this.statementtimeout);
        attrList.put("lazy-connection-association", this.lazyconnectionassociation);
        attrList.put("lazy-connection-enlistment", this.lazyconnectionenlistment);
        attrList.put("associate-with-thread", this.associatewiththread);
        attrList.put("match-connections", this.matchconnections);
        attrList.put("max-connection-usage-count", this.maxconnectionusagecount);
        attrList.put("wrap-jdbc-objects", this.wrapjdbcobjects);
        try {
            JDBCConnectionPoolManager connPoolMgr = new JDBCConnectionPoolManager();
            rs = connPoolMgr.create(this.resources, attrList, this.properties, this.jdbc_connection_pool_id);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} creation failed", new Object[]{this.jdbc_connection_pool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == ResourceStatus.FAILURE) {
            ec = ActionReport.ExitCode.FAILURE;
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} creation failed", new Object[]{this.jdbc_connection_pool_id}));
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        } else {
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.success", "JDBC connection pool {0} created successfully", new Object[]{this.jdbc_connection_pool_id}));
        }
        report.setActionExitCode(ec);
    }
}

