/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-ssl")
@Scoped(value=PerLookup.class)
@I18n(value="create.ssl")
public class CreateSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSsl.class);
    @Param(name="certname")
    String certName;
    @Param(name="type")
    String type;
    @Param(name="ssl2enabled", optional=true)
    String ssl2Enabled = Boolean.TRUE.toString();
    @Param(name="ssl2ciphers", optional=true)
    String ssl2ciphers;
    @Param(name="ssl3enabled", optional=true)
    String ssl3Enabled = Boolean.TRUE.toString();
    @Param(name="ssl3tlsciphers", optional=true)
    String ssl3tlsciphers;
    @Param(name="tlsenabled", optional=true)
    String tlsenabled = Boolean.TRUE.toString();
    @Param(name="tlsrollbackenabled", optional=true)
    String tlsrollbackenabled = Boolean.TRUE.toString();
    @Param(name="clientauthenabled", optional=true)
    String clientauthenabled = Boolean.TRUE.toString();
    @Param(optional=true)
    String target;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        if (this.type.equals("http-listener")) {
            this.addSslToHTTPListener(config, report);
        } else if (this.type.equals("iiop-listener")) {
            this.addSslToIIOPListener(config, report);
        }
    }

    private void addSslToIIOPListener(Config config, ActionReport report) {
        IiopService iiopService = config.getIiopService();
        IiopListener iiopListener = null;
        for (IiopListener listener : iiopService.getIiopListener()) {
            if (!listener.getId().equals(this.listenerId)) continue;
            iiopListener = listener;
        }
        if (iiopListener == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.iiop.notfound", "IIOP Listener named {0} to which this ssl element is being added does not exist.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (iiopListener.getSsl() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.iiop.alreadyExists", "IIOP Listener named {0} to which this ssl element is being added already has an ssl element.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopListener>(){

                public Object run(IiopListener param) throws PropertyVetoException, TransactionFailure {
                    Ssl newSsl = (Ssl)ConfigSupport.createChildOf((Object)param, Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)iiopListener);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }

    private void addSslToHTTPListener(Config config, ActionReport report) {
        HttpService httpService = config.getHttpService();
        HttpListener httpListener = null;
        for (HttpListener listener : httpService.getHttpListener()) {
            if (!listener.getId().equals(this.listenerId)) continue;
            httpListener = listener;
        }
        if (httpListener == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.http.notfound", "Http Listener named {0} to which this ssl element is being added does not exist.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (httpListener.getSsl() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.http.alreadyExists", "Http Listener named {0} to which this ssl element is being added already has an ssl element.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpListener>(){

                public Object run(HttpListener param) throws PropertyVetoException, TransactionFailure {
                    Ssl newSsl = (Ssl)ConfigSupport.createChildOf((Object)param, Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)httpListener);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }

    private void reportError(ActionReport report, TransactionFailure e) {
        report.setMessage(localStrings.getLocalString("create.ssl.fail", "Creation of Ssl in {0} failed", new Object[]{this.listenerId}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause((Throwable)e);
    }

    private void reportSuccess(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("create.ssl.success", "Creation of Ssl in {0} completed successfully", new Object[]{this.listenerId}));
    }

    private void populateSslElement(Ssl newSsl) throws PropertyVetoException {
        newSsl.setCertNickname(this.certName);
        newSsl.setClientAuthEnabled(this.clientauthenabled);
        newSsl.setSsl2Ciphers(this.ssl2ciphers);
        newSsl.setSsl2Enabled(this.ssl2Enabled);
        newSsl.setSsl3Enabled(this.ssl3Enabled);
        newSsl.setSsl3TlsCiphers(this.ssl3tlsciphers);
        newSsl.setTlsEnabled(this.tlsenabled);
        newSsl.setTlsRollbackEnabled(this.tlsrollbackenabled);
    }
}

