/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JDBCConnectionPoolManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.connection.pool")
public class DeleteJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcConnectionPool.class);
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Resources resources;
    @Inject
    JdbcConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JDBCConnectionPoolManager jdbcConnMgr = new JDBCConnectionPoolManager();
            ResourceStatus rs = jdbcConnMgr.delete(this.resources, this.connPools, this.jdbc_connection_pool_id);
            if (rs.getStatus() == ResourceStatus.SUCCESS) {
                report.setMessage(rs.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setMessage(rs.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.jdbc.connection.pool.fail", "{0} delete failed ", new Object[]{this.jdbc_connection_pool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

