/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-ssl")
@Scoped(value=PerLookup.class)
@I18n(value="delete.ssl")
public class DeleteSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSsl.class);
    @Param(name="type")
    String type;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Inject
    HttpService httpService;
    @Inject
    IiopService iiopService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.type.equals("http-listener")) {
                HttpListener httpListener = null;
                for (HttpListener listener : this.httpService.getHttpListener()) {
                    if (!listener.getId().equals(this.listenerId)) continue;
                    httpListener = listener;
                }
                if (httpListener == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.http.listener.notfound", "HTTP Listener named {0} not found", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpListener>(){

                    public Object run(HttpListener param) throws PropertyVetoException, TransactionFailure {
                        param.setSsl(null);
                        return null;
                    }
                }, httpListener);
            } else if (this.type.equals("iiop-listener")) {
                IiopListener iiopListener = null;
                for (IiopListener listener : this.iiopService.getIiopListener()) {
                    if (!listener.getId().equals(this.listenerId)) continue;
                    iiopListener = listener;
                }
                if (iiopListener == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.iiop.listener.notfound", "Iiop Listener named {0} not found", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopListener>(){

                    public Object run(IiopListener param) throws PropertyVetoException, TransactionFailure {
                        param.setSsl(null);
                        return null;
                    }
                }, iiopListener);
            }
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.ssl.fail", "Deletion of Ssl in {0} failed", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setMessage(localStrings.getLocalString("delete.ssl.success", "Deletion of Ssl in {0} completed successfully", new Object[]{this.listenerId}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

