/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.v3.admin.Resource;
import com.sun.enterprise.v3.admin.ResourceFactory;
import com.sun.enterprise.v3.admin.ResourceManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import com.sun.enterprise.v3.admin.ResourcesXMLParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ResourcesManager {
    public ArrayList createResources(Resources resources, String resourceXMLFile, String tgtName) throws Exception {
        ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
        ResourcesXMLParser resourcesParser = new ResourcesXMLParser(resourceXMLFile);
        List vResources = resourcesParser.getResourcesList();
        for (Resource resource : ResourcesXMLParser.getNonConnectorResourcesList(vResources, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = ResourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, tgtName);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(ResourceStatus.FAILURE, msg);
            }
            results.add(rs);
        }
        for (Resource resource : ResourcesXMLParser.getConnectorResourcesList(vResources, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = ResourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, tgtName);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(ResourceStatus.FAILURE, msg);
            }
            results.add(rs);
        }
        return results;
    }
}

