/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEnvironment {
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kApplicationDirName = "j2ee-apps";
    public static final String kModuleDirName = "j2ee-modules";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kLoggingPropertiesFileNAme = "logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String kCompileJspDirName = "jsp";
    private final String root;
    private final StartupContext startupContext;
    private final boolean verbose;
    private final boolean debug;
    private static final ASenvPropertyReader asenv = new ASenvPropertyReader();
    private final String domainName;
    private final String instanceName;

    public ServerEnvironment(String root, StartupContext startupContext) {
        this.root = root;
        this.startupContext = startupContext;
        asenv.getProps().put("com.sun.aas.instanceRoot", root);
        Map args = startupContext.getArguments();
        this.verbose = Boolean.parseBoolean((String)args.get("-verbose"));
        this.debug = Boolean.parseBoolean((String)args.get("-debug"));
        String s = (String)startupContext.getArguments().get("-domainname");
        if (!this.ok(s)) {
            try {
                s = new File(root).getName();
            }
            catch (Exception e) {
                s = "";
            }
        }
        this.domainName = s;
        s = (String)startupContext.getArguments().get("-instancename");
        this.instanceName = !this.ok(s) ? "server" : s;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainRoot() {
        return this.root;
    }

    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    public String getConfigDirPath() {
        String[] folderNames = new String[]{this.root, kConfigDirName};
        return StringUtils.makeFilePath((String[])folderNames, (boolean)false);
    }

    public String getApplicationRepositoryPath() {
        String[] onlyFolderNames = new String[]{this.root, kRepositoryDirName};
        return StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getApplicationStubPath() {
        String[] onlyFolderNames = new String[]{this.root, kGeneratedDirName};
        return StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getInitFilePath() {
        String[] fileNames = new String[]{this.root, kConfigDirName, kInitFileName};
        return StringUtils.makeFilePath((String[])fileNames, (boolean)false);
    }

    public String getLibPath() {
        String[] fileNames = new String[]{this.root, "lib"};
        return StringUtils.makeFilePath((String[])fileNames, (boolean)false);
    }

    public String getApplicationGeneratedXMLPath() {
        return null;
    }

    public String getApplicationCompileJspPath() {
        String[] onlyFolderNames = new String[]{this.root, kGeneratedDirName, kCompileJspDirName};
        return StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getWebModuleCompileJspPath() {
        return this.getApplicationCompileJspPath();
    }

    public String getModuleRepositoryPath() {
        return null;
    }

    public String getJavaWebStartPath() {
        return null;
    }

    public String getApplicationBackupRepositoryPath() {
        return null;
    }

    public String getInstanceClassPath() {
        return null;
    }

    public String getModuleStubPath() {
        return null;
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(asenv.getProps());
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

