/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ContextRootMapper;
import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.HttpProtocolFilter;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Adapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttp
extends SelectorThread
implements EndpointMapper<Adapter> {
    private static final String ROOT = "/";
    private ContextRootMapper mapper;
    protected volatile ProtocolFilter httpProtocolFilterWrapper;
    private AtomicBoolean algorithInitialized = new AtomicBoolean(false);
    protected volatile Collection<ProtocolFilter> defaultHttpFilters;
    protected boolean isHttpSecured = false;

    public GrizzlyEmbeddedHttp() {
        this(null);
    }

    public GrizzlyEmbeddedHttp(Controller controller) {
        this.controller = controller;
        this.mapper = new ContextRootMapper(this);
    }

    protected void initAlgorithm() {
        if (!this.algorithInitialized.getAndSet(true)) {
            super.initAlgorithm();
        }
    }

    protected void initController() {
        super.initController();
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

            public ProtocolChain poll() {
                Object protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new GlassfishProtocolChain();
                    GrizzlyEmbeddedHttp.this.configureFilters((ProtocolChain)protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)instanceHandler);
        this.controller.setReadThreadsCount(this.readThreadsCount);
        this.controller.addSelectorHandler((SelectorHandler)this.createUDPSelectorHandler());
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
            return;
        }
        ProtocolFilter readFilter = this.createReadFilter();
        protocolChain.addFilter(readFilter);
        if (this.rcmSupport) {
            protocolChain.addFilter(this.createRaFilter());
        }
        protocolChain.addFilter((ProtocolFilter)this.getHttpProtocolFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ProtocolFilter> getDefaultHttpProtocolFilters() {
        if (this.defaultHttpFilters == null) {
            GrizzlyEmbeddedHttp grizzlyEmbeddedHttp = this;
            synchronized (grizzlyEmbeddedHttp) {
                if (this.defaultHttpFilters == null) {
                    ArrayList<ProtocolFilter> tmpList = new ArrayList<ProtocolFilter>(4);
                    if (this.rcmSupport) {
                        tmpList.add(this.createRaFilter());
                    }
                    tmpList.add(this.createHttpParserFilter());
                    this.defaultHttpFilters = tmpList;
                }
            }
        }
        return this.defaultHttpFilters;
    }

    public ProcessorTask getProcessorTask() {
        if (this.asyncExecution) {
            HttpWorkerThread httpWorkerThread = (HttpWorkerThread)Thread.currentThread();
            DefaultProcessorTask contextPt = (DefaultProcessorTask)httpWorkerThread.getProcessorTask();
            if (contextPt == null) {
                return super.getProcessorTask();
            }
            DefaultProcessorTask pt = (DefaultProcessorTask)super.getProcessorTask();
            if (contextPt != null) {
                pt.setAdapter(contextPt.getAdapter());
            }
            return pt;
        }
        return super.getProcessorTask();
    }

    protected ProtocolFilter createReadFilter() {
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(true);
        return readFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpProtocolFilter getHttpProtocolFilter() {
        if (this.httpProtocolFilterWrapper == null) {
            GrizzlyEmbeddedHttp grizzlyEmbeddedHttp = this;
            synchronized (grizzlyEmbeddedHttp) {
                if (this.httpProtocolFilterWrapper == null) {
                    this.initAlgorithm();
                    ProtocolFilter wrappedFilter = this.createHttpParserFilter();
                    this.httpProtocolFilterWrapper = new HttpProtocolFilter(wrappedFilter, this);
                }
            }
        }
        return (HttpProtocolFilter)this.httpProtocolFilterWrapper;
    }

    protected UDPSelectorHandler createUDPSelectorHandler() {
        UDPSelectorHandler udpSelectorHandler = new UDPSelectorHandler();
        udpSelectorHandler.setPort(this.port);
        udpSelectorHandler.setPipeline((Pipeline)this.processorPipeline);
        return udpSelectorHandler;
    }

    protected void configureSelectorHandler(UDPSelectorHandler selectorHandler) {
        selectorHandler.setPort(this.port);
        selectorHandler.setReuseAddress(this.getReuseAddress());
        selectorHandler.setPipeline((Pipeline)this.processorPipeline);
    }

    public boolean isHttpSecured() {
        return this.isHttpSecured;
    }

    public ContextRootMapper getContextRootMapper() {
        return this.mapper;
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        this.mapper.register(this.ensureStartsWithSlash(contextRoot), adapter, null, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        this.mapper.unregister(this.ensureStartsWithSlash(contextRoot));
    }

    private String ensureStartsWithSlash(String path) {
        if (!path.startsWith(ROOT)) {
            return ROOT + path;
        }
        return path;
    }
}

