/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttps;
import com.sun.enterprise.v3.services.impl.WebProtocolHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.http.portunif.HttpProtocolFinder;
import com.sun.grizzly.portunif.TLSPUPreProcessor;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyServiceListener {
    private Controller controller;
    private int port;
    private boolean isEmbeddedHttpSecured;
    private GrizzlyEmbeddedHttp embeddedHttp;
    private String name;

    public GrizzlyServiceListener() {
    }

    public GrizzlyServiceListener(Controller controller) {
        this.controller = controller;
    }

    public void start() throws IOException, InstantiationException {
        this.embeddedHttp.initEndpoint();
        this.embeddedHttp.startEndpoint();
    }

    public void stop() {
        this.embeddedHttp.stopEndpoint();
    }

    public void initializeEmbeddedHttp(boolean isSecured) {
        this.isEmbeddedHttpSecured = isSecured;
        this.embeddedHttp = isSecured ? new GrizzlyEmbeddedHttps() : new GrizzlyEmbeddedHttp();
        this.embeddedHttp.setPort(this.port);
    }

    public EndpointMapper<Adapter> configureEndpointMapper(boolean isWebProfileMode) {
        if (!isWebProfileMode) {
            WebProtocolHandler.Mode webProtocolHandlerMode;
            ArrayList<TLSPUPreProcessor> puPreProcessors = new ArrayList<TLSPUPreProcessor>();
            if (this.isEmbeddedHttpSecured) {
                SSLContext sslContext = ((GrizzlyEmbeddedHttps)this.embeddedHttp).getSSLContext();
                TLSPUPreProcessor preProcessor = new TLSPUPreProcessor(sslContext);
                puPreProcessors.add(preProcessor);
                webProtocolHandlerMode = WebProtocolHandler.Mode.HTTPS;
            } else {
                webProtocolHandlerMode = WebProtocolHandler.Mode.HTTP;
            }
            ArrayList<HttpProtocolFinder> protocolFinders = new ArrayList<HttpProtocolFinder>();
            protocolFinders.add(new HttpProtocolFinder());
            ArrayList<WebProtocolHandler> protocolHandlers = new ArrayList<WebProtocolHandler>();
            WebProtocolHandler webProtocolHandler = new WebProtocolHandler(webProtocolHandlerMode, this.embeddedHttp);
            protocolHandlers.add(webProtocolHandler);
            this.embeddedHttp.configurePortUnification(protocolFinders, protocolHandlers, puPreProcessors);
        }
        return this.embeddedHttp;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public GrizzlyEmbeddedHttp getEmbeddedHttp() {
        return this.embeddedHttp;
    }

    public boolean isEmbeddedHttpSecured() {
        return this.isEmbeddedHttpSecured;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        if (this.embeddedHttp != null) {
            this.embeddedHttp.setPort(port);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

