/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.grizzly.util.buf.Ascii;
import java.io.IOException;
import java.nio.ByteBuffer;

public class HttpUtils {
    public static String findContextRoot(ByteBuffer byteBuffer) throws IOException {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            throw new IllegalStateException("Invalid state");
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        int separatorPos = -1;
        int lastPos = -1;
        try {
            block9: while (byteBuffer.hasRemaining()) {
                byte c = byteBuffer.get();
                switch (state) {
                    case 0: {
                        if (c != 32) continue block9;
                        state = 1;
                        lastPos = start = byteBuffer.position();
                        continue block9;
                    }
                    case 1: {
                        if (c == 47 && separatorPos == -1) {
                            if (byteBuffer.position() != lastPos + 1) {
                                separatorPos = byteBuffer.position() - 1;
                                continue block9;
                            }
                            if (byteBuffer.position() - 1 == start) {
                                lastPos = start = byteBuffer.position();
                                continue block9;
                            }
                            lastPos = byteBuffer.position();
                            continue block9;
                        }
                        if (c != 32) continue block9;
                        end = separatorPos != -1 ? separatorPos : byteBuffer.position() - 1;
                        if (byteBuffer.hasArray()) {
                            String string = new String(byteBuffer.array(), byteBuffer.arrayOffset() + start, end - start);
                            return string;
                        }
                        byte[] contextRoot = new byte[end - start];
                        byteBuffer.position(start);
                        byteBuffer.limit(end);
                        byteBuffer.get(contextRoot);
                        String string = new String(contextRoot);
                        return string;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            throw new IllegalStateException("Invalid request");
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findBytes(ByteBuffer byteBuffer, byte[] b) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            throw new IllegalStateException("Invalid state");
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        try {
            byte first = b[0];
            int start = 0;
            int end = curPosition;
            int srcEnd = b.length;
            for (int i = start; i <= end - srcEnd; ++i) {
                if (Ascii.toLower((int)byteBuffer.get(i)) != first) continue;
                int myPos = i + 1;
                int srcPos = 1;
                while (srcPos < srcEnd && Ascii.toLower((int)byteBuffer.get(myPos++)) == b[srcPos++]) {
                    if (srcPos != srcEnd) continue;
                    int n = i - start;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findHost(ByteBuffer byteBuffer) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        try {
            block12: while (byteBuffer.hasRemaining()) {
                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                switch (state) {
                    case 0: {
                        if (c == 104) {
                            state = 1;
                            continue block12;
                        }
                        state = 0;
                        continue block12;
                    }
                    case 1: {
                        if (c == 111) {
                            state = 2;
                            continue block12;
                        }
                        state = 0;
                        continue block12;
                    }
                    case 2: {
                        if (c == 115) {
                            state = 3;
                            continue block12;
                        }
                        state = 0;
                        continue block12;
                    }
                    case 3: {
                        if (c == 116) {
                            state = 4;
                            continue block12;
                        }
                        state = 0;
                        continue block12;
                    }
                    case 4: {
                        if (c == 58) {
                            state = 5;
                            continue block12;
                        }
                        state = 0;
                        continue block12;
                    }
                    case 5: {
                        String result;
                        if (byteBuffer.hasArray()) {
                            int startPos;
                            int endPos = startPos = byteBuffer.position();
                            while (c != 13 && c != 10) {
                                ++endPos;
                                c = byteBuffer.get();
                            }
                            result = new String(byteBuffer.array(), byteBuffer.arrayOffset() + startPos, endPos - startPos);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            while (c != 13 && c != 10) {
                                sb.append((char)c);
                                c = byteBuffer.get();
                            }
                            result = sb.toString();
                        }
                        String string = result.trim();
                        return string;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            String string = null;
            return string;
        }
        finally {
            if (end > 0) {
                byteBuffer.position(start);
                byteBuffer.limit(end);
            } else {
                byteBuffer.limit(curLimit);
                byteBuffer.position(curPosition);
            }
        }
    }
}

