/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils.converters;

import com.sun.org.apache.commons.beanutils.ConversionException;
import com.sun.org.apache.commons.beanutils.Converter;

public final class ClassConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public ClassConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ClassConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Class) {
            return value;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassConverter.class.getClassLoader();
            }
            return classLoader.loadClass(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

